/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultTableColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultValueFactory;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchResultBooleanCell;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class EFCSearchResultBooleanColumn
extends EFCSearchResultTableColumn<Boolean> {
    public EFCSearchResultBooleanColumn(final String name, final boolean editable) {
        super(Translator.tr((String)("FLD_" + name.toUpperCase())));
        this.setId(name);
        this.setEditable(editable);
        this.setCellFactory((Callback)new Callback<TableColumn<SearchResult, Boolean>, TableCell<SearchResult, Boolean>>(){

            public TableCell<SearchResult, Boolean> call(TableColumn<SearchResult, Boolean> param) {
                return new EFCSearchResultBooleanCell(name, editable);
            }
        });
        this.setCellValueFactory(new EFCSearchResultValueFactory<Boolean>((Object)name.toUpperCase()){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<SearchResult, Boolean> cdf) {
                SearchResult result = (SearchResult)cdf.getValue();
                Map map = result.getData();
                String resultString = (String)map.get(this.getKey());
                Boolean bResult = null;
                if (resultString != null) {
                    bResult = new EFCBoolean(resultString).getData();
                }
                if (bResult == null) {
                    return null;
                }
                return new SimpleBooleanProperty(bResult.booleanValue());
            }
        });
        this.setPrefWidth(50.0);
    }

    @Override
    public Class<?> getColumnClass() {
        return EFCBoolean.class;
    }
}

