/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns;

import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.editor.util.DateFormatter;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultTableColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultValueFactory;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchResultStringCell;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EUFieldStyler;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.apache.commons.lang3.ClassUtils;

public class EFCSearchResultColumn
extends EFCSearchResultTableColumn<String> {
    private Class<?> columnClass;

    public EFCSearchResultColumn(final SearchService.SearchColumnInfo critColInfo) {
        Comparator<String> comparator;
        this.columnClass = critColInfo.getClazz();
        String columnName = Translator.tr((String)("FLD_" + critColInfo.getName().toUpperCase()));
        this.setText(columnName);
        this.setId(critColInfo.getName());
        this.setCellFactory((Callback)new Callback<TableColumn<SearchResult, String>, TableCell<SearchResult, String>>(){

            public TableCell<SearchResult, String> call(TableColumn<SearchResult, String> tableColumn) {
                EFCSearchResultStringCell cell = new EFCSearchResultStringCell(EFCSearchResultColumn.this.columnClass);
                return cell;
            }
        });
        if (this.columnClass == EFCDate.class) {
            comparator = new Comparator<String>(){

                @Override
                public int compare(String r1, String r2) {
                    if (r1 == null || r1.isEmpty()) {
                        return -1;
                    }
                    if (r2 == null || r2.isEmpty()) {
                        return 1;
                    }
                    Date date1 = DateFormatter.convertDate(r1);
                    Date date2 = DateFormatter.convertDate(r2);
                    return date1.compareTo(date2);
                }
            };
            this.setComparator(comparator);
        }
        if (this.columnClass == EFCDateTime.class) {
            comparator = new Comparator<String>(){

                @Override
                public int compare(String r1, String r2) {
                    if (r1 == null || r1.isEmpty()) {
                        return -1;
                    }
                    if (r2 == null || r2.isEmpty()) {
                        return 1;
                    }
                    Date date1 = DateTimeFormatter.convertDate(r1);
                    Date date2 = DateTimeFormatter.convertDate(r2);
                    return date1.compareTo(date2);
                }
            };
            this.setComparator(comparator);
        }
        if (NumberType.class.isAssignableFrom(this.columnClass)) {
            comparator = this.columnClass == EFCOption.class ? new Comparator<String>(){

                @Override
                public int compare(String r1, String r2) {
                    return r1.compareTo(r2);
                }
            } : new Comparator<String>(){

                @Override
                public int compare(String r1, String r2) {
                    Double n1 = null;
                    Double n2 = null;
                    try {
                        EUFieldStyler.getInstance();
                        n1 = EUFieldStyler.getDoubleForNumberType(r1, EFCSearchResultColumn.this.columnClass);
                        EUFieldStyler.getInstance();
                        n2 = EUFieldStyler.getDoubleForNumberType(r2, EFCSearchResultColumn.this.columnClass);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (n1 == null) {
                        return -1;
                    }
                    if (n2 == null) {
                        return 1;
                    }
                    return n1.compareTo(n2);
                }
            };
            this.setComparator(comparator);
        }
        this.setCellValueFactory(new EFCSearchResultValueFactory<String>((Object)critColInfo.getName().toUpperCase()){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<SearchResult, String> cdf) {
                SearchResult result = (SearchResult)cdf.getValue();
                Map map = result.getData();
                String resultString = (String)map.get(this.getKey());
                if (critColInfo.getClazz().equals(EFCOption.class)) {
                    Class optionClazz = null;
                    try {
                        optionClazz = ClassUtils.getClass((String)critColInfo.getOptionClass());
                    }
                    catch (ClassNotFoundException ex) {
                        EFCDesktop.reportError(ex);
                    }
                    String optionValue = null;
                    for (Field field : optionClazz.getFields()) {
                        Object value = null;
                        try {
                            value = field.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException exception) {
                            // empty catch block
                        }
                        if (value == null || resultString == null || resultString.isEmpty() || ((Integer)value).intValue() != Integer.valueOf(resultString).intValue()) continue;
                        optionValue = field.getName().toUpperCase();
                        break;
                    }
                    if (optionClazz != null && optionValue != null) {
                        String optClassName = optionClazz.getSimpleName().toUpperCase();
                        String key = "OPT_" + optClassName + "_" + optionValue + "_S";
                        resultString = Translator.tr((String)key);
                    }
                } else {
                    resultString = EUFieldStyler.getStringForType(resultString, EFCSearchResultColumn.this.columnClass);
                }
                SimpleStringProperty resultProp = resultString != null ? new SimpleStringProperty(resultString.toString()) : new SimpleStringProperty();
                return resultProp;
            }
        });
    }

    @Override
    public Class<?> getColumnClass() {
        return this.columnClass;
    }
}

