/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class AcceptOnExitTableCell<S, T>
extends TableCell<S, T> {
    private TextField textField;
    private boolean escapePressed = false;
    private TablePosition<S, ?> tablePos = null;
    private String initValue = null;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return AcceptOnExitTableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new AcceptOnExitTableCell(converter);
    }

    public AcceptOnExitTableCell() {
        this(null);
    }

    public AcceptOnExitTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"text-field-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.textField == null) {
                this.textField = this.getTextField();
            }
            this.escapePressed = false;
            this.startEdit(this.textField);
            TableView table = this.getTableView();
            this.tablePos = table.getEditingCell();
        }
    }

    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        TableView table = this.getTableView();
        if (table != null) {
            TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(table, this.tablePos, TableColumn.editCommitEvent(), newValue);
            Event.fireEvent((EventTarget)this.getTableColumn(), (Event)editEvent);
        }
        super.cancelEdit();
        this.updateItem(newValue, false);
        if (table != null) {
            table.edit(-1, null);
        }
    }

    public void cancelEdit() {
        if (this.escapePressed) {
            super.cancelEdit();
        } else {
            String newText = this.textField.getText();
            this.commitEdit(this.getConverter().fromString(newText));
        }
        this.setGraphic(null);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateItem();
    }

    private TextField getTextField() {
        TextField textField = new TextField(this.getItemText());
        textField.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.TAB) {
                if (this.converter == null) {
                    throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
                }
                this.commitEdit(this.getConverter().fromString(textField.getText()));
                t.consume();
            }
        });
        return textField;
    }

    private String getItemText() {
        return this.getConverter() == null ? (this.getItem() == null ? "" : this.getItem().toString()) : this.getConverter().toString(this.getItem());
    }

    public String getInitValue() {
        return this.initValue;
    }

    public void setInitValue(String initValue) {
        this.initValue = initValue;
    }

    private void updateItem() {
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getItemText());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getItemText());
            this.setGraphic(null);
        }
    }

    private void startEdit(TextField textField) {
        if (textField != null) {
            if ((textField.getText() == null || textField.getText().isEmpty()) && this.initValue != null) {
                textField.setText(this.initValue);
            } else {
                textField.setText(this.getItemText());
            }
        }
        this.setText(null);
        this.setGraphic((Node)textField);
        textField.selectAll();
        textField.requestFocus();
    }
}

