/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.base.datatypes.EFCBoolean;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class EFCSearchCriteriaBooleanCell
extends TableCell<Map<String, String>, Boolean> {
    private CheckBox checkBox;
    private boolean isEmpty = true;

    public EFCSearchCriteriaBooleanCell(String id, final boolean editable) {
        this.setAlignment(Pos.CENTER);
        this.setId(id);
        this.setEditable(editable);
        this.checkBox = new CheckBox(){

            public void arm() {
                if (editable) {
                    super.arm();
                }
            }
        };
        if (editable) {
            this.checkBox.setDisable(true);
        }
        this.getStyleClass().add((Object)"efcsearchcheckboxcell");
        this.checkBox.getStyleClass().add((Object)"efcsearchcheckbox");
        this.checkBox.setAllowIndeterminate(true);
        this.checkBox.setIndeterminate(true);
        EventHandler<ActionEvent> eh = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (event.getSource() == EFCSearchCriteriaBooleanCell.this.checkBox) {
                    boolean isSelected = EFCSearchCriteriaBooleanCell.this.checkBox.isSelected();
                    boolean isIndeterminate = EFCSearchCriteriaBooleanCell.this.checkBox.isIndeterminate();
                    if (!isIndeterminate) {
                        ((Map)EFCSearchCriteriaBooleanCell.this.getTableView().getItems().get(EFCSearchCriteriaBooleanCell.this.getTableRow().getIndex())).put(EFCSearchCriteriaBooleanCell.this.getId().toUpperCase(), String.valueOf(new EFCBoolean(Boolean.valueOf(isSelected)).getInt()));
                    } else {
                        ((Map)EFCSearchCriteriaBooleanCell.this.getTableView().getItems().get(EFCSearchCriteriaBooleanCell.this.getTableRow().getIndex())).put(EFCSearchCriteriaBooleanCell.this.getId().toUpperCase(), String.valueOf(new EFCBoolean().getInt()));
                    }
                }
            }
        };
        this.checkBox.setOnAction((EventHandler)eh);
        EventHandler<MouseEvent> clickHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && !EFCSearchCriteriaBooleanCell.this.isEmpty && ((String)((Map)EFCSearchCriteriaBooleanCell.this.getTableView().getItems().get(EFCSearchCriteriaBooleanCell.this.getTableRow().getIndex())).get(EFCSearchCriteriaBooleanCell.this.getId().toUpperCase())).equals("-1")) {
                    EFCSearchCriteriaBooleanCell.this.isEmpty = true;
                    EFCSearchCriteriaBooleanCell.this.checkBox.setSelected(false);
                    EFCSearchCriteriaBooleanCell.this.checkBox.setIndeterminate(true);
                    EFCSearchCriteriaBooleanCell.this.checkBox.setDisable(true);
                    ((Map)EFCSearchCriteriaBooleanCell.this.getTableView().getItems().get(EFCSearchCriteriaBooleanCell.this.getTableRow().getIndex())).remove(EFCSearchCriteriaBooleanCell.this.getId().toUpperCase());
                } else if (event.getButton() == MouseButton.PRIMARY && EFCSearchCriteriaBooleanCell.this.isEmpty) {
                    EFCSearchCriteriaBooleanCell.this.startEdit();
                    ((Map)EFCSearchCriteriaBooleanCell.this.getTableView().getItems().get(EFCSearchCriteriaBooleanCell.this.getTableRow().getIndex())).put(EFCSearchCriteriaBooleanCell.this.getId().toUpperCase(), String.valueOf(new EFCBoolean().getInt()));
                }
            }
        };
        this.setOnMouseClicked((EventHandler)clickHandler);
        this.checkBox.setOnMouseClicked((EventHandler)clickHandler);
        this.setGraphic((Node)this.checkBox);
        this.setEditable(true);
    }

    public boolean isIndeterminate() {
        return this.checkBox.isIndeterminate();
    }

    public void startEdit() {
        if (this.getTableRow().indexProperty().get() == 0 || this.getTableRow().indexProperty().get() == 1) {
            super.startEdit();
            this.isEmpty = false;
            this.checkBox.setDisable(false);
            this.checkBox.requestFocus();
        }
    }

    public boolean empty() {
        return this.isEmpty;
    }

    public void commitEdit(Boolean value) {
        super.commitEdit((Object)value);
        if (this.isEmpty) {
            this.checkBox.setDisable(true);
        }
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.checkBox.setIndeterminate(true);
        } else {
            if (item.booleanValue()) {
                item.toString();
            }
            this.checkBox.setIndeterminate(false);
            this.checkBox.setSelected(item.booleanValue());
        }
    }

    public void setValue(Object value) {
        if (value == null) {
            this.checkBox.setIndeterminate(true);
        } else {
            this.checkBox.setIndeterminate(false);
            if (value instanceof Boolean) {
                this.checkBox.setSelected(((Boolean)value).booleanValue());
            } else if (value instanceof EFCBoolean) {
                this.checkBox.setSelected(((EFCBoolean)value).getBoolean().booleanValue());
            }
        }
    }

    public CheckBox getComponent() {
        return this.checkBox;
    }

    public Boolean getValue() {
        return this.checkBox.selectedProperty().getValue();
    }
}

