/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.base.i18n.Translator;
import java.util.Collection;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.cell.ComboBoxTableCell;

public class EFCSearchOptionCell
extends ComboBoxTableCell<Map<String, String>, CBEntry> {
    public EFCSearchOptionCell(Class<?> optionClass) {
        this.getStyleClass().add((Object)"efcsearchoptioncell");
        Map options = OptionObject.getValues(optionClass);
        ObservableList optionList = FXCollections.observableArrayList();
        options.entrySet().forEach(entry -> optionList.add((Object)new CBEntry(new EFCOption(optionClass, (Integer)entry.getValue()))));
        optionList.sort((a, b) -> a.getValue().getData().compareTo(b.getValue().getData()));
        this.getItems().add((Object)new CBEntry());
        this.getItems().addAll((Collection)optionList);
        this.setOnMouseClicked(event -> this.startEdit());
        this.setEditable(true);
    }

    public void startEdit() {
        int row = this.getTableRow().indexProperty().get();
        if (row != 2 && row != 5 && row != 6) {
            super.startEdit();
            ((ComboBox)this.getGraphic()).setOnAction(event -> this.commitEdit((CBEntry)((ComboBox)this.getGraphic()).getSelectionModel().getSelectedItem()));
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
    }

    public void commitEdit(CBEntry value) {
        super.commitEdit((Object)value);
        if (value != null && value.getValue() != null) {
            ((Map)this.getTableView().getItems().get(this.getTableRow().getIndex())).put(this.getTableColumn().getId().toUpperCase(), String.valueOf(value.getValue().getData()));
        } else {
            ((Map)this.getTableView().getItems().get(this.getTableRow().getIndex())).remove(this.getTableColumn().getId().toUpperCase());
        }
    }

    public void updateItem(CBEntry item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || item.getValue() == null || item.getValue().getData() == null || empty) {
            this.setText(null);
        } else {
            this.setText(Translator.tr((String)item.genKeyShort()));
        }
    }

    public static class CBEntry {
        private EFCOption value;

        public CBEntry() {
        }

        public CBEntry(EFCOption option) {
            this.value = option;
        }

        public String genKey() {
            String key = "OPT_" + this.value.getOptionClass().getSimpleName().toUpperCase() + "_" + this.value.toString();
            return key;
        }

        public String genKeyShort() {
            String key = "OPT_" + this.value.getOptionClass().getSimpleName().toUpperCase() + "_" + this.value.toString().toUpperCase() + "_S";
            return key;
        }

        public String toString() {
            if (this.value != null) {
                return Translator.tr((String)this.genKey());
            }
            return "";
        }

        public EFCOption getValue() {
            return this.value;
        }

        public void setValue(EFCOption value) {
            this.value = value;
        }
    }
}

