/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.gui.data.SearchResult;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;

public class EFCSearchResultBooleanCell
extends TableCell<SearchResult, Boolean> {
    private CheckBox checkBox;
    private boolean isEmpty = true;

    public EFCSearchResultBooleanCell(String id, final boolean editable) {
        this.setAlignment(Pos.CENTER);
        this.setId(id);
        this.setEditable(editable);
        this.checkBox = new CheckBox(){

            public void arm() {
                if (editable) {
                    super.arm();
                }
            }
        };
        if (editable) {
            this.checkBox.setDisable(true);
        }
        this.getStyleClass().add((Object)"efcsearchcheckboxcell");
        this.checkBox.getStyleClass().add((Object)"efcsearchcheckbox");
        this.checkBox.setAllowIndeterminate(true);
        this.checkBox.setIndeterminate(true);
        this.setGraphic((Node)this.checkBox);
        this.setEditable(true);
    }

    public boolean isIndeterminate() {
        return this.checkBox.isIndeterminate();
    }

    public void startEdit() {
        if (this.getTableRow().indexProperty().get() == 0) {
            super.startEdit();
            this.isEmpty = false;
            this.checkBox.setDisable(false);
            this.checkBox.requestFocus();
        }
    }

    public boolean empty() {
        return this.isEmpty;
    }

    public void commitEdit(Boolean value) {
        super.commitEdit((Object)value);
        if (this.isEmpty) {
            this.checkBox.setDisable(true);
        }
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.checkBox.setIndeterminate(true);
        } else {
            if (item.booleanValue()) {
                item.toString();
            }
            this.checkBox.setIndeterminate(false);
            this.checkBox.setSelected(item.booleanValue());
        }
    }

    public void setValue(Object value) {
        if (value == null) {
            this.checkBox.setIndeterminate(true);
        } else {
            this.checkBox.setIndeterminate(false);
            if (value instanceof Boolean) {
                this.checkBox.setSelected(((Boolean)value).booleanValue());
            } else if (value instanceof EFCBoolean) {
                this.checkBox.setSelected(((EFCBoolean)value).getBoolean().booleanValue());
            }
        }
    }

    public CheckBox getComponent() {
        return this.checkBox;
    }

    public Boolean getValue() {
        return this.checkBox.selectedProperty().getValue();
    }
}

