/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.gui.data.SearchResult;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class EFCSearchResultStringCell
extends TableCell<SearchResult, String> {
    public EFCSearchResultStringCell(Class<?> columnClass) {
        this.setGraphic((Node)new Text());
        this.setPrefHeight(Double.NEGATIVE_INFINITY);
        this.setOnDragDetected(new DragDetectedEventHandler(this));
        this.setOnMouseDragEntered(new DragEnteredEventHandler(this));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (EFCSearchResultStringCell.this.getTableView().getSelectionModel().getSelectionMode() == SelectionMode.SINGLE) {
                    int index = EFCSearchResultStringCell.this.getIndex();
                    if (index >= 0 && index < EFCSearchResultStringCell.this.getTableView().getItems().size() && EFCSearchResultStringCell.this.getTableView().getSelectionModel().isSelected(index)) {
                        EFCSearchResultStringCell.this.getTableView().getSelectionModel().clearSelection();
                        event.consume();
                    }
                } else if (EFCSearchResultStringCell.this.getTableView().getSelectionModel().getSelectedCells().size() == 1) {
                    EFCSearchResultStringCell.this.getTableView().getSelectionModel().clearSelection();
                    event.consume();
                }
            }
        });
        this.setOnMouseDragOver((EventHandler)new EventHandler<MouseDragEvent>(){

            public void handle(MouseDragEvent event) {
                if (EFCSearchResultStringCell.this.getTableView().getSelectionModel().getSelectionMode() == SelectionMode.MULTIPLE && EFCSearchResultStringCell.this.getTableView().getSelectionModel().isCellSelectionEnabled()) {
                    if (event.getSource() instanceof TableCell && event.getGestureSource() instanceof TableCell) {
                        TableCell start = (TableCell)event.getGestureSource();
                        TableCell stop = (TableCell)event.getSource();
                        if (start.getTableRow().getIndex() < stop.getTableRow().getIndex()) {
                            EFCSearchResultStringCell.this.getTableColumn().getTableView().getSelectionModel().selectRange(start.getTableRow().getIndex(), (TableColumnBase)start.getTableColumn(), stop.getTableRow().getIndex(), (TableColumnBase)stop.getTableColumn());
                        } else {
                            EFCSearchResultStringCell.this.getTableColumn().getTableView().getSelectionModel().selectRange(stop.getTableRow().getIndex(), (TableColumnBase)stop.getTableColumn(), start.getTableRow().getIndex(), (TableColumnBase)start.getTableColumn());
                        }
                    }
                } else {
                    event.consume();
                }
            }
        });
        if (EFCOption.class == columnClass || EFCDate.class == columnClass || EFCDateTime.class == columnClass || EFCCalWeek.class == columnClass || EFCCalMonth.class == columnClass) {
            this.setAlignment(Pos.BASELINE_CENTER);
        }
        if (NumberType.class.isAssignableFrom(columnClass)) {
            this.setAlignment(Pos.CENTER_RIGHT);
        }
        if (EFCDate.class == columnClass || EFCDateTime.class == columnClass || EFCCalWeek.class == columnClass || EFCCalMonth.class == columnClass) {
            this.setAlignment(Pos.CENTER);
        }
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        SearchResult searchResult = (SearchResult)this.getTableRow().getItem();
        String id = this.getId();
        java.awt.Color cellColor = null;
        if (id != null && searchResult != null && (cellColor = searchResult.getAttrColor(id)) != java.awt.Color.white) {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)cellColor.getRed(), (int)cellColor.getGreen(), (int)cellColor.getBlue(), (double)0.6), CornerRadii.EMPTY, Insets.EMPTY)}));
        }
        if (item == null || empty) {
            this.setText(null);
        } else {
            this.setText(item);
        }
    }

    protected void performSelection(TableView<SearchResult> table, TableColumn<SearchResult, String> column, int index) {
        TablePositionBase anchor = (TablePositionBase)TableCellBehavior.getAnchor(table, (Object)table.getFocusModel().getFocusedCell());
        int columnIndex = table.getVisibleLeafIndex(column);
        int minRowIndex = Math.min(anchor.getRow(), index);
        int maxRowIndex = Math.max(anchor.getRow(), index);
        TableColumnBase minColumn = anchor.getColumn() < columnIndex ? anchor.getTableColumn() : column;
        TableColumnBase maxColumn = anchor.getColumn() >= columnIndex ? anchor.getTableColumn() : column;
        table.getSelectionModel().clearSelection();
        int minColumnIndex = table.getVisibleLeafIndex((TableColumn)minColumn);
        int maxColumnIndex = table.getVisibleLeafIndex((TableColumn)maxColumn);
        for (int _row = minRowIndex; _row <= maxRowIndex; ++_row) {
            for (int _col = minColumnIndex; _col <= maxColumnIndex; ++_col) {
                table.getSelectionModel().select(_row, table.getVisibleLeafColumn(_col));
            }
        }
        table.getFocusModel().focus(index, (TableColumn)column);
    }

    public class ControlDownSelectionEventHandler
    implements EventHandler<KeyEvent> {
        public void handle(KeyEvent event) {
            KeyCode code = event.getCode();
            if (event.isShiftDown() && (KeyCode.UP.equals((Object)code) || KeyCode.DOWN.equals((Object)code) || KeyCode.LEFT.equals((Object)code) || KeyCode.RIGHT.equals((Object)code))) {
                int index = EFCSearchResultStringCell.this.getTableView().getFocusModel().getFocusedCell().getRow();
                TableColumn column = EFCSearchResultStringCell.this.getTableView().getFocusModel().getFocusedCell().getTableColumn();
                EFCSearchResultStringCell.this.performSelection((TableView<SearchResult>)EFCSearchResultStringCell.this.getTableView(), (TableColumn<SearchResult, String>)column, index);
            }
        }
    }

    public class DragEnteredEventHandler
    implements EventHandler<MouseDragEvent> {
        TableCell<SearchResult, String> tableCell;

        public DragEnteredEventHandler(TableCell<SearchResult, String> tableCell) {
            this.tableCell = tableCell;
        }

        public void handle(MouseDragEvent event) {
            EFCSearchResultStringCell.this.performSelection((TableView<SearchResult>)this.tableCell.getTableView(), (TableColumn<SearchResult, String>)this.tableCell.getTableColumn(), this.tableCell.getIndex());
        }
    }

    public class DragDetectedEventHandler
    implements EventHandler<MouseEvent> {
        TableCell<SearchResult, String> tableCell;

        public DragDetectedEventHandler(TableCell<SearchResult, String> tableCell) {
            this.tableCell = tableCell;
        }

        public void handle(MouseEvent event) {
            this.tableCell.startFullDrag();
        }
    }
}

