/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCDays;
import de.effectivecompany.base.datatypes.EFCFileName;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCTelNum;
import de.effectivecompany.gui.components.editor.util.DateFormatter;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.AcceptOnExitTableCell;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;

public class EFCSearchStringCell
extends AcceptOnExitTableCell<Map<String, String>, String> {
    private Class<?> columnClass;

    public EFCSearchStringCell(final Class<?> columnClass) {
        this.columnClass = columnClass;
        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.setOnMouseClicked(event -> this.startEdit());
        this.setConverter(new StringConverter<String>(){

            public String fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    if (EFCDate.class == columnClass) {
                        if (!string.contains("H") && !string.contains("T")) {
                            string = DateFormat.getDateInstance().format(DateFormatter.convertDate(string));
                        }
                    } else if (EFCDateTime.class == columnClass && !string.contains("H") && !string.contains("T")) {
                        string = DateFormat.getDateTimeInstance().format(DateTimeFormatter.convertDate(string));
                    }
                }
                return string;
            }

            public String toString(String object) {
                return object;
            }
        });
        this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (EFCSearchStringCell.this.getTableView().getSelectionModel().getSelectionMode() == SelectionMode.MULTIPLE && EFCSearchStringCell.this.getTableView().getSelectionModel().isCellSelectionEnabled()) {
                    EFCSearchStringCell.this.startFullDrag();
                } else {
                    event.consume();
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                int index = EFCSearchStringCell.this.getIndex();
                if (index >= 0 && index < EFCSearchStringCell.this.getTableView().getItems().size() && EFCSearchStringCell.this.getTableView().getSelectionModel().isSelected(index)) {
                    EFCSearchStringCell.this.getTableView().getSelectionModel().clearSelection();
                    event.consume();
                }
            }
        });
        this.setOnMouseDragOver((EventHandler)new EventHandler<MouseDragEvent>(){

            public void handle(MouseDragEvent event) {
                if (EFCSearchStringCell.this.getTableView().getSelectionModel().getSelectionMode() == SelectionMode.MULTIPLE && EFCSearchStringCell.this.getTableView().getSelectionModel().isCellSelectionEnabled()) {
                    if (event.getSource() instanceof TableCell && event.getGestureSource() instanceof TableCell) {
                        TableCell start = (TableCell)event.getGestureSource();
                        TableCell stop = (TableCell)event.getSource();
                        if (start.getTableRow().getIndex() < stop.getTableRow().getIndex()) {
                            EFCSearchStringCell.this.getTableColumn().getTableView().getSelectionModel().selectRange(start.getTableRow().getIndex(), (TableColumnBase)start.getTableColumn(), stop.getTableRow().getIndex(), (TableColumnBase)stop.getTableColumn());
                        } else {
                            EFCSearchStringCell.this.getTableColumn().getTableView().getSelectionModel().selectRange(stop.getTableRow().getIndex(), (TableColumnBase)stop.getTableColumn(), start.getTableRow().getIndex(), (TableColumnBase)start.getTableColumn());
                        }
                    }
                } else {
                    event.consume();
                }
            }
        });
        if (EFCOption.class.isAssignableFrom(columnClass)) {
            this.setAlignment(Pos.CENTER_LEFT);
        } else {
            if (EFCInteger.class.isAssignableFrom(columnClass) || EFCLong.class.isAssignableFrom(columnClass) || EFCFloat.class.isAssignableFrom(columnClass) || Number.class.isAssignableFrom(columnClass)) {
                this.setAlignment(Pos.CENTER_RIGHT);
            }
            if (EFCDate.class.isAssignableFrom(columnClass) || Date.class.isAssignableFrom(columnClass) || EFCDateTime.class.isAssignableFrom(columnClass) || EFCCalWeek.class.isAssignableFrom(columnClass) || EFCCalMonth.class.isAssignableFrom(columnClass)) {
                this.setAlignment(Pos.CENTER);
            }
        }
        if (EFCInteger.class.isAssignableFrom(columnClass) || EFCLong.class.isAssignableFrom(columnClass) || EFCFloat.class.isAssignableFrom(columnClass) || Number.class.isAssignableFrom(columnClass)) {
            this.setAlignment(Pos.CENTER_RIGHT);
        }
        if (EFCDate.class.isAssignableFrom(columnClass) || Date.class.isAssignableFrom(columnClass) || EFCDateTime.class.isAssignableFrom(columnClass) || EFCCalWeek.class.isAssignableFrom(columnClass) || EFCCalMonth.class.isAssignableFrom(columnClass)) {
            this.setAlignment(Pos.CENTER);
        }
    }

    @Override
    public void updateItem(String item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setText(null);
        } else {
            this.setText(item);
            this.setPrefHeight(this.getTableRow().getHeight());
        }
    }

    @Override
    public void commitEdit(String newValue) {
        super.commitEdit(newValue);
        ((Map)this.getTableView().getItems().get(this.getTableRow().getIndex())).put(this.getTableColumn().getId().toUpperCase(), newValue);
    }

    @Override
    public void startEdit() {
        boolean isEditable = true;
        int row = this.getTableRow().indexProperty().get();
        if (EFCTelNum.class.isAssignableFrom(this.columnClass)) {
            isEditable = row != 3 && row != 4;
        } else if (EFCFileName.class.isAssignableFrom(this.columnClass)) {
            isEditable = row != 3 && row != 4;
        } else if (EFCDate.class.isAssignableFrom(this.columnClass) || EFCDateTime.class.isAssignableFrom(this.columnClass)) {
            isEditable = row < 5 && row != 2;
        } else if (EFCLong.class.isAssignableFrom(this.columnClass) || EFCInteger.class.isAssignableFrom(this.columnClass) || EFCFloat.class.isAssignableFrom(this.columnClass) || EFCDays.class.isAssignableFrom(this.columnClass)) {
            boolean bl = isEditable = row < 5 && row != 2;
        }
        if (isEditable) {
            if (row == 0 || row == 1) {
                // empty if block
            }
            this.setPrefHeight(this.getTableRow().getHeight());
            super.startEdit();
        }
    }
}

