/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class EFCFxButton
extends Button {
    static PseudoClass unrevealedPseudo = PseudoClass.getPseudoClass((String)"unrevealed");
    static PseudoClass revealedPseudo = PseudoClass.getPseudoClass((String)"revealed");
    static PseudoClass normalPseudo = PseudoClass.getPseudoClass((String)"normal");
    static PseudoClass toolbarPseudo = PseudoClass.getPseudoClass((String)"toolbar");

    public EFCFxButton(String id, Image image, String toolTip) {
        if (image != null) {
            ImageView view = new ImageView(image);
            if (EFCLookAndFeelManager.SIZE_MULTIPLIER != 1.0) {
                view.setFitHeight(image.getHeight() * EFCLookAndFeelManager.SIZE_MULTIPLIER);
                view.setFitWidth(image.getWidth() * EFCLookAndFeelManager.SIZE_MULTIPLIER);
                view.setSmooth(true);
            }
            this.setAlignment(Pos.CENTER);
            this.setGraphic((Node)view);
        }
        if (toolTip != null && !toolTip.isEmpty()) {
            Tooltip tool = new Tooltip(toolTip);
            tool.getStyleClass().add((Object)"ttip");
            this.setTooltip(tool);
        }
        this.getStyleClass().add((Object)"efcbutton");
        this.setId(id);
        this.setMinHeight(29.0);
        this.setMinWidth(29.0);
    }

    public EFCFxButton(String text, String id, Image image, String toolTip) {
        this(id, image, toolTip);
        this.setText(text);
    }

    public EFCFxButton(final EFCAbstractAction action, ButtonState position) {
        if (action.getText() != null) {
            if (action.getAccelerator() != null) {
                this.setText(action.getAccelerator().getDisplayText() + "-" + action.getText());
            } else {
                this.setText(action.getText());
            }
        }
        this.setAlignment(Pos.CENTER);
        String toolTip = action.getLongText();
        if (toolTip != null && !toolTip.isEmpty()) {
            Tooltip tool = new Tooltip(toolTip);
            tool.getStyleClass().add((Object)"ttip");
            this.setTooltip(tool);
        }
        this.changePseudoClass(position);
        this.graphicProperty().bindBidirectional((Property)action.graphicProperty());
        this.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setEventHandler(ActionEvent.ACTION, (EventHandler)action);
        if (action.getAccelerator() != null) {
            Platform.runLater(() -> this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                    if (newValue != null) {
                        newValue.getAccelerators().put((Object)action.getAccelerator(), (Object)new Runnable(){

                            @Override
                            public void run() {
                                EFCFxButton.this.fire();
                            }
                        });
                    }
                }
            }));
        }
        this.getStyleClass().add((Object)"efcbutton");
        this.setId(action.getIdent());
    }

    public void setTextInvisible(boolean isVisible) {
        if (!isVisible) {
            this.changePseudoClass(TextState.HIDE);
        } else {
            this.changePseudoClass(TextState.VISIBLE);
        }
    }

    public void requestFocus() {
    }

    public void changePseudoClass(TextState state) {
        this.pseudoClassStateChanged(unrevealedPseudo, false);
        this.pseudoClassStateChanged(revealedPseudo, false);
        switch (state) {
            case HIDE: {
                this.pseudoClassStateChanged(revealedPseudo, true);
                break;
            }
            case VISIBLE: {
                this.pseudoClassStateChanged(unrevealedPseudo, true);
            }
        }
    }

    public void changePseudoClass(ButtonState state) {
        this.pseudoClassStateChanged(normalPseudo, false);
        this.pseudoClassStateChanged(toolbarPseudo, false);
        switch (state) {
            case NORMAL: {
                this.pseudoClassStateChanged(normalPseudo, true);
                break;
            }
            case TOOLBAR: {
                this.pseudoClassStateChanged(toolbarPseudo, true);
            }
        }
    }

    public static enum ButtonState {
        NORMAL,
        TOOLBAR;

    }

    public static enum TextState {
        VISIBLE,
        HIDE;

    }
}

