/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.frame.EFCMenuFavouriteInfo;
import de.effectivecompany.gui.components.fx.EFCMenuFavouriteItem;
import de.effectivecompany.gui.components.fx.EFCToolBar;
import de.effectivecompany.gui.components.fx.components.EFCDropDownButton;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.fx.event.EFCActionInternalFrame;
import de.effectivecompany.gui.components.fx.event.EFCActionMenuFavouriteDelete;
import de.effectivecompany.gui.components.fx.event.EFCActionMenuFavouriteOrder;
import de.effectivecompany.gui.components.fx.event.EFCActionMenuFavouriteRename;
import de.effectivecompany.gui.components.fx.event.EFCActionMenuFavouriteStart;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.root.EFCNavigator;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCMenu;
import de.effectivecompany.gui.constants.EFCMenuElement;
import de.effectivecompany.gui.constants.EFCPredefinedMenu;
import de.effectivecompany.gui.constants.EFCPredefinedToolBar;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.ImageView;
import javax.swing.JInternalFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMainMenu
extends MenuBar {
    public static final long serialVersionUID = -154532L;
    private static Logger logger = LoggerFactory.getLogger(EFCMainMenu.class);
    private Map<EFCAction, EFCAbstractAction> actions;
    private EFCPredefinedToolBar predefinedToolbar;
    private EFCToolBar toolbar;
    private Menu cMenuFrames;
    private Menu cMenuFavorites;

    public EFCMainMenu() {
        this(EFCPredefinedMenu.M_FRAME_MASTER, EFCPredefinedToolBar.DEFAULT);
    }

    public EFCMainMenu(EFCPredefinedMenu predefMenu) {
        this(predefMenu, EFCPredefinedToolBar.DEFAULT);
    }

    public EFCMainMenu(EFCPredefinedMenu predefMenu, EFCPredefinedToolBar predefinedToolbar) {
        this.predefinedToolbar = predefinedToolbar;
        this.initActions();
        for (EFCMenu menuItem : predefMenu.getMenuElements()) {
            this.addItem(null, menuItem);
        }
    }

    private void initActions() {
        this.actions = new LinkedHashMap<EFCAction, EFCAbstractAction>();
        for (EFCAction action : EFCAction.values()) {
            this.actions.put(action, action.newActionFx());
        }
    }

    public void addMenuFramesItem(EFCInternalFrameView frame) {
        if (frame != null) {
            this.addItem(this.cMenuFrames, new EFCActionInternalFrame(frame));
        } else {
            this.cMenuFrames.getItems().add((Object)new MenuItem(Translator.tr((String)"MENU_NO_FRAMES")));
        }
    }

    public void addMenuFavoriteItem(EFCMenuFavouriteInfo info, EFCNavigator.ExecProg sysProg) {
        if (sysProg != null) {
            this.cMenuFavorites.getItems().add((Object)new EFCMenuFavouriteItem(new EFCActionMenuFavouriteStart(info, sysProg), info.getOrder()));
        }
    }

    private void addMenuFavoriteItemDelete(EFCMenuFavouriteInfo info, EFCNavigator.ExecProg sysProg) {
        if (sysProg != null) {
            this.cMenuFavorites.getItems().add((Object)new EFCMenuFavouriteItem(new EFCActionMenuFavouriteDelete(info, sysProg, this), info.getOrder()));
        }
    }

    private void addMenuFavoriteItemRename(EFCMenuFavouriteInfo info, EFCNavigator.ExecProg sysProg) {
        if (sysProg != null) {
            this.cMenuFavorites.getItems().add((Object)new EFCMenuFavouriteItem(new EFCActionMenuFavouriteRename(info, sysProg, this), info.getOrder()));
        }
    }

    private void addMenuFavoriteItemOrder(EFCMenuFavouriteInfo info, EFCNavigator.ExecProg sysProg) {
        if (sysProg != null) {
            this.cMenuFavorites.getItems().add((Object)new EFCMenuFavouriteItem(new EFCActionMenuFavouriteOrder(info, sysProg), info.getOrder(), true));
        }
    }

    public void switchMenuFavourite() {
        Menu editMenu = new Menu(Translator.tr((String)"ACTION_EDIT_MENUFAVOURITES"));
        this.cMenuFavorites.getItems().clear();
        EFCMenuFavouriteItem remove = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_DELETE_MENUFAVOURITES"));
        remove.setOnAction(event -> {
            this.switchMenuFavouriteDelete();
            this.cMenuFavorites.show();
        });
        EFCMenuFavouriteItem rename = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_RENAME_MENUFAVOURITES"));
        rename.setOnAction(event -> {
            this.switchMenuFavouriteRename();
            this.cMenuFavorites.show();
        });
        EFCMenuFavouriteItem order = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_ORDER_MENUFAVOURITES"));
        order.setOnAction(event -> {
            this.switchMenuFavouriteOrder();
            this.cMenuFavorites.show();
        });
        editMenu.getItems().addAll((Object[])new MenuItem[]{remove, rename, order});
        EFCPanelSingleton.getInstance();
        for (EFCMenuFavouriteInfo info : EFCPanelSingleton.getMenuFavouriteList(EFCMainFrame.class.getSimpleName())) {
            this.addMenuFavoriteItem(info, EFCNavigator.getInstance().getProgram(info.getSysProg()));
        }
        this.cMenuFavorites.getItems().add((Object)new SeparatorMenuItem());
        this.cMenuFavorites.getItems().add((Object)editMenu);
        this.sortMenuFavourites();
    }

    private void sortMenuFavourites() {
        this.cMenuFavorites.getItems().setAll((Collection)this.cMenuFavorites.getItems().stream().sorted((i1, i2) -> {
            if (i1 instanceof EFCMenuFavouriteItem && i2 instanceof EFCMenuFavouriteItem) {
                if (((EFCMenuFavouriteItem)((Object)i1)).getAction() != null && ((EFCMenuFavouriteItem)((Object)i1)).getAction().getInfo() != null && ((EFCMenuFavouriteItem)((Object)i1)).getAction().getInfo().getOrder() != null && ((EFCMenuFavouriteItem)((Object)i2)).getAction() != null && ((EFCMenuFavouriteItem)((Object)i2)).getAction().getInfo() != null && ((EFCMenuFavouriteItem)((Object)i2)).getAction().getInfo().getOrder() != null) {
                    return ((EFCMenuFavouriteItem)((Object)i1)).getAction().getInfo().getOrder().compareTo(((EFCMenuFavouriteItem)((Object)i2)).getAction().getInfo().getOrder());
                }
                return 0;
            }
            return 0;
        }).collect(Collectors.toList()));
    }

    public void switchMenuFavouriteDelete() {
        this.cMenuFavorites.getItems().clear();
        EFCMenuFavouriteItem remove = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_EXIT_DELETE_MENUFAVOURITES"));
        remove.setOnAction(event -> {
            this.switchMenuFavourite();
            this.cMenuFavorites.show();
        });
        EFCPanelSingleton.getInstance();
        for (EFCMenuFavouriteInfo info : EFCPanelSingleton.getMenuFavouriteList(EFCMainFrame.class.getSimpleName())) {
            this.addMenuFavoriteItemDelete(info, EFCNavigator.getInstance().getProgram(info.getSysProg()));
        }
        this.cMenuFavorites.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), remove});
        this.sortMenuFavourites();
    }

    public void switchMenuFavouriteRename() {
        this.cMenuFavorites.getItems().clear();
        EFCMenuFavouriteItem exitRename = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_EXIT_RENAME_MENUFAVOURITES"));
        exitRename.setOnAction(event -> {
            this.switchMenuFavourite();
            this.cMenuFavorites.show();
        });
        EFCPanelSingleton.getInstance();
        for (EFCMenuFavouriteInfo info : EFCPanelSingleton.getMenuFavouriteList(EFCMainFrame.class.getSimpleName())) {
            this.addMenuFavoriteItemRename(info, EFCNavigator.getInstance().getProgram(info.getSysProg()));
        }
        this.cMenuFavorites.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), exitRename});
        this.sortMenuFavourites();
    }

    public void switchMenuFavouriteOrder() {
        this.cMenuFavorites.getItems().clear();
        EFCMenuFavouriteItem exitOrder = new EFCMenuFavouriteItem(Translator.tr((String)"ACTION_EXIT_ORDER_MENUFAVOURITES"));
        EFCList menuFavoList = new EFCList();
        exitOrder.setOnAction(event -> {
            for (int i = 0; i < EFCMainFrame.getInstance().getPanel().getMenu().getMenuFavourite().getItems().size(); ++i) {
                MenuItem i1 = (MenuItem)EFCMainFrame.getInstance().getPanel().getMenu().getMenuFavourite().getItems().get(i);
                if (!(i1 instanceof EFCMenuFavouriteItem) || ((EFCMenuFavouriteItem)i1).getAction() == null) continue;
                EFCActionMenuFavouriteOrder action = (EFCActionMenuFavouriteOrder)((EFCMenuFavouriteItem)i1).getAction();
                action.getInfo().setOrder(i + 1);
                menuFavoList.add((Object)action.getInfo());
            }
            EFCPanelSingleton.getInstance().setMenuFavouriteOrder((List<EFCMenuFavouriteInfo>)menuFavoList);
        });
        EFCPanelSingleton.getInstance();
        for (EFCMenuFavouriteInfo info : EFCPanelSingleton.getMenuFavouriteList(EFCMainFrame.class.getSimpleName())) {
            this.addMenuFavoriteItemOrder(info, EFCNavigator.getInstance().getProgram(info.getSysProg()));
        }
        this.cMenuFavorites.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), exitOrder});
        this.sortMenuFavourites();
    }

    private Menu addItem(Menu parent, EFCMenuElement item) {
        Menu menu = null;
        if (item instanceof EFCAction) {
            EFCAction action = (EFCAction)item;
            EFCAbstractAction efcaction = this.actions.get(action);
            if (EFCLookAndFeelManager.isAdmin || !action.isOnlyForAdmin()) {
                MenuItem menuitem = new MenuItem();
                menuitem.setText(efcaction.getText());
                menuitem.setOnAction((EventHandler)efcaction);
                menuitem.setMnemonicParsing(true);
                final AtomicReference<MenuItem> ref = new AtomicReference<MenuItem>(menuitem);
                efcaction.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        ((MenuItem)ref.get()).setDisable(newValue.booleanValue());
                    }
                });
                if (efcaction.getGraphic() != null) {
                    menuitem.setGraphic((Node)new ImageView(((ImageView)efcaction.getGraphic()).getImage()));
                }
                menuitem.setAccelerator(efcaction.getAccelerator());
                parent.getItems().add((Object)menuitem);
            }
        } else if (item.isMenuSeparator()) {
            parent.getItems().add((Object)new SeparatorMenuItem());
        } else if (item instanceof EFCMenu) {
            EFCMenu efcMenu = (EFCMenu)item;
            menu = new Menu(Translator.tr((String)efcMenu.getMenuItemName()));
            if (efcMenu == EFCMenu.M_FAVORITES) {
                this.cMenuFavorites = menu;
                this.cMenuFavorites.setOnAction(e -> this.cMenuFavorites.show());
                this.switchMenuFavourite();
            }
            if (efcMenu == EFCMenu.M_FRAMES) {
                this.cMenuFrames = menu;
                this.setOnMouseEntered(e -> {
                    int counter = 0;
                    this.cMenuFrames.getItems().clear();
                    for (JInternalFrame frame : EFCDesktop.getInstance().getAllFrames()) {
                        if (!(frame instanceof EFCInternalFrameView)) continue;
                        this.addMenuFramesItem((EFCInternalFrameView)frame);
                        ++counter;
                    }
                    if (counter == 0) {
                        this.addMenuFramesItem(null);
                    }
                });
            }
            menu.setVisible(efcMenu.isVisible());
            if (parent != null) {
                parent.getItems().add((Object)menu);
            } else {
                this.getMenus().add((Object)menu);
            }
            for (EFCMenuElement subItem : item.getElements()) {
                Menu subMenu = this.addItem(menu, subItem);
                if (subMenu == null) continue;
                menu.getItems().add((Object)subMenu);
            }
        }
        return menu;
    }

    public Menu getMenuFavourite() {
        return this.cMenuFavorites;
    }

    private MenuItem addItem(Menu menu, EFCAbstractAction action) {
        MenuItem menuitem = null;
        if (action != null) {
            menuitem = new MenuItem();
            menuitem.setText(action.getText());
            menuitem.setOnAction((EventHandler)action);
            menuitem.setMnemonicParsing(true);
            final AtomicReference<MenuItem> ref = new AtomicReference<MenuItem>(menuitem);
            action.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    ((MenuItem)ref.get()).setDisable(newValue.booleanValue());
                }
            });
            if (action.getGraphic() != null) {
                menuitem.setGraphic((Node)new ImageView(((ImageView)action.getGraphic()).getImage()));
            }
            menuitem.setAccelerator(action.getAccelerator());
            menu.getItems().add((Object)menuitem);
        }
        return menuitem;
    }

    public void setEnabledActions(EnumSet<EFCAction> bitmask) {
        EFCAction.M_ALL.forEach(action -> {
            EFCAbstractAction efcAction = this.getAction((EFCAction)action);
            if (efcAction != null) {
                efcAction.setDisabled(true);
            }
        });
        bitmask.forEach(action -> {
            EFCAbstractAction efcAction = this.getAction((EFCAction)action);
            if (efcAction != null) {
                efcAction.setDisabled(false);
            }
        });
    }

    public void enableActions(EFCAction ... menu) {
        for (EFCAction action : menu) {
            EFCAbstractAction efcAction = this.getAction(action);
            if (efcAction == null) continue;
            efcAction.setDisabled(false);
        }
    }

    public void disableActions(EFCAction ... menu) {
        for (EFCAction action : menu) {
            EFCAbstractAction efcAction = this.getAction(action);
            if (efcAction == null) continue;
            efcAction.setDisabled(true);
        }
    }

    public void setActionHandler(ActionHandler handler) {
        for (Map.Entry<EFCAction, EFCAbstractAction> entry : this.actions.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            entry.getValue().setActionHandler(handler);
        }
    }

    public void removeActionHandlers() {
        for (Map.Entry<EFCAction, EFCAbstractAction> entry : this.actions.entrySet()) {
            entry.getValue().removeActionHandler();
        }
    }

    public EFCAbstractAction getAction(EFCAction constant) {
        EFCAbstractAction action = this.actions.get(constant);
        if (action == null) {
            logger.error("EFC Action not initialized MenuConstant: " + constant.name());
        }
        return action;
    }

    public EFCToolBar getToolBar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        this.toolbar = new EFCToolBar(this);
        for (EFCMenuElement element : this.predefinedToolbar.getElements()) {
            EFCAction action;
            if (element instanceof EFCAction) {
                action = (EFCAction)element;
                this.toolbar.add(this.getAction(action));
                continue;
            }
            if (element.isMenuSeparator()) {
                this.toolbar.getItems().add((Object)new Separator());
                continue;
            }
            if (element.getElements().isEmpty()) continue;
            action = (EFCAction)element.getElements().get(0);
            EFCDropDownButton dropDown = this.createDropDownButton(this.toolbar, action);
            for (EFCMenuElement dropMenuElement : element.getElements()) {
                if (dropMenuElement instanceof EFCAction) {
                    EFCAction dropaction = (EFCAction)dropMenuElement;
                    dropDown.addDropdown(this.getAction(dropaction));
                    continue;
                }
                if (!dropMenuElement.isMenuSeparator()) continue;
                dropDown.addSeparator();
            }
        }
        return this.toolbar;
    }

    private EFCDropDownButton createDropDownButton(EFCToolBar toolbar, EFCAction a) {
        EFCDropDownButton button = new EFCDropDownButton(this.getAction(a));
        toolbar.getItems().add((Object)button);
        return button;
    }

    public Menu getMenu(EFCMenu menuconst) {
        for (Menu menu : this.getMenus()) {
            if (menu.getText() == null || menuconst.getMenuItemName() == null || !menu.getText().equals(Translator.tr((String)menuconst.getMenuItemName()))) continue;
            return menu;
        }
        return null;
    }

    public Map<EFCAction, EFCAbstractAction> getActions() {
        return this.actions;
    }
}

