/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.gui.components.fx.EFCPDFBoxViewer;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPDFBoxThumbNailPane
extends ScrollPane {
    private static Logger logger = LoggerFactory.getLogger(EFCPDFBoxThumbNailPane.class);
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    private boolean drawing;
    private boolean interrupt;
    private List<Button> pageButton;
    private final VBox content;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private BufferedImage[] images;
    private boolean[] buttonDrawn;
    private final BorderListener border;
    private final Border selectedBorder;
    private final Border hoverBorder;
    private final Border emptyBorder;
    private EFCPDFBoxViewer parent;
    private PDDocument document;
    private PDFRenderer pdfRenderer;

    public EFCPDFBoxThumbNailPane(EFCPDFBoxViewer parent) {
        this.parent = parent;
        this.border = new BorderListener();
        this.content = new VBox();
        this.content.setAlignment(Pos.CENTER);
        this.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds oldb, Bounds newb) {
                EFCPDFBoxThumbNailPane.this.content.setPrefWidth(newb.getWidth());
                if (EFCPDFBoxThumbNailPane.this.drawing) {
                    EFCPDFBoxThumbNailPane.this.terminateDrawing();
                }
                EFCPDFBoxThumbNailPane.this.drawThumbnails();
            }
        });
        this.vvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                if (EFCPDFBoxThumbNailPane.this.drawing) {
                    EFCPDFBoxThumbNailPane.this.terminateDrawing();
                }
                EFCPDFBoxThumbNailPane.this.drawThumbnails();
            }
        });
        this.selectedBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.RED, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.hoverBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.emptyBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.setContent((Node)this.content);
    }

    public void terminateDrawing() {
        if (this.drawing) {
            this.interrupt = true;
        }
    }

    public void setupThumbnails(PDDocument document, PDFRenderer renderer, Font textFont, String message) {
        if (document != null) {
            int pages = document.getNumberOfPages();
            this.document = document;
            this.pdfRenderer = renderer;
            this.content.getChildren().clear();
            this.isLandscape = new boolean[pages];
            this.pageHeight = new int[pages];
            this.pageButton = new ArrayList<Button>();
            this.images = new BufferedImage[pages];
            this.buttonDrawn = new boolean[pages];
            Stream<PDPage> stream = StreamSupport.stream(document.getPages().spliterator(), true);
            PDPageTree pageTree = document.getPages();
            stream.forEach(page -> {
                int i = pageTree.indexOf(page);
                int rotation = page.getRotation();
                int ph = (int)page.getMediaBox().getHeight();
                EFCThreadUtil.doLaterFAT(() -> {
                    if (rotation == 90 || rotation == 270) {
                        javafx.scene.image.Image blankImage = EFCPDFBoxThumbNailPane.createBlankThumbnail(100, 70);
                        Button imageButton = new Button(message + " " + (i + 1), (Node)new ImageView(blankImage));
                        this.pageButton.add(imageButton);
                        try {
                            BufferedImage img = this.pdfRenderer.renderImage(i, 0.15f);
                            if (!this.interrupt) {
                                EFCThreadUtil.doLaterFAT(() -> this.createThumbnail(img, i));
                            }
                        }
                        catch (Throwable thro) {
                            logger.error("", thro);
                        }
                        this.isLandscape[i] = true;
                    } else {
                        javafx.scene.image.Image blankImage = EFCPDFBoxThumbNailPane.createBlankThumbnail(70, 100);
                        Button imageButton = new Button(message + " " + (i + 1), (Node)new ImageView(blankImage));
                        this.pageButton.add(imageButton);
                        try {
                            BufferedImage img = this.pdfRenderer.renderImage(i, 0.15f);
                            if (!this.interrupt) {
                                EFCThreadUtil.doLaterFAT(() -> this.createThumbnail(img, i));
                            }
                        }
                        catch (Throwable thro) {
                            logger.error("", thro);
                        }
                        this.isLandscape[i] = false;
                    }
                    this.pageButton.get(i).setContentDisplay(ContentDisplay.TOP);
                    this.pageButton.get(i).setStyle("-fx-padding:0;-fx-background-color:transparent;");
                    if (i == 0 && pages > 1) {
                        this.pageButton.get(i).setBorder(this.selectedBorder);
                    } else {
                        this.pageButton.get(i).setBorder(this.emptyBorder);
                    }
                    this.pageButton.get(i).prefWidthProperty().bind((ObservableValue)this.content.prefWidthProperty());
                    this.content.getChildren().add((Object)((Node)this.pageButton.get(i)));
                    this.pageButton.get(i).setOnMouseEntered((EventHandler)this.border);
                    this.pageButton.get(i).setOnMouseExited((EventHandler)this.border);
                    this.pageButton.get(i).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent e) {
                            int index = EFCPDFBoxThumbNailPane.this.pageButton.indexOf(e.getSource());
                            if (index != -1) {
                                EFCThreadUtil.doLaterFAT(() -> EFCPDFBoxThumbNailPane.this.parent.goToPage(index + 1));
                            }
                            e.toString();
                        }
                    });
                    if (rotation == 90 || rotation == 270) {
                        this.setPrefWidth(140.0);
                    } else {
                        this.setPrefWidth(110.0);
                    }
                });
                this.pageHeight[i] = ph;
            });
        }
    }

    public BufferedImage rotate(BufferedImage img, double angle) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(angle), img.getWidth() / 2, img.getHeight() / 2);
        BufferedImage rotatedImage = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
        g.setTransform(affineTransform);
        g.drawImage((Image)img, 0, 0, null);
        return rotatedImage;
    }

    public void drawThumbnails() {
    }

    private static javafx.scene.image.Image createBlankThumbnail(int w, int h) {
        Canvas canvas = new Canvas((double)w, (double)h);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setFill((Paint)Color.WHITE);
        gc.fillRect(0.2, 0.2, (double)w - 0.5, (double)h - 0.5);
        gc.setFill((Paint)Color.BLACK);
        gc.strokeRect(0.2, 0.2, (double)w - 0.5, (double)h - 0.5);
        gc.strokeLine(0.0, 0.0, (double)w, (double)h);
        gc.strokeLine(0.0, (double)h, (double)w, 0.0);
        return canvas.snapshot(null, null);
    }

    private void createThumbnail(BufferedImage page, int i) {
        if (page != null) {
            try {
                WritableImage image = SwingFXUtils.toFXImage((BufferedImage)page, null);
                ((ImageView)this.pageButton.get(i).getGraphic()).setImage((javafx.scene.image.Image)image);
                this.buttonDrawn[i] = true;
                this.images[i] = page;
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        }
    }

    public void updateSelection(int selectedPage) {
        if (this.pageButton != null) {
            for (int i = 0; i < this.pageButton.size(); ++i) {
                if (i == selectedPage - 1) {
                    this.pageButton.get(i).setBorder(this.selectedBorder);
                    continue;
                }
                this.pageButton.get(i).setBorder(this.emptyBorder);
            }
        }
    }

    public static final class ImageRotater {
        private ImageRotater() {
        }

        public static BufferedImage rotateImage(BufferedImage src, double degrees) {
            Point srcSize = new Point(src.getWidth(), src.getHeight());
            Point dstSize = ImageRotater.rectangleExtendAfterRotation(srcSize.x, srcSize.y, degrees);
            int correctionX = dstSize.x - srcSize.x;
            int correctionY = dstSize.y - srcSize.y;
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(degrees), srcSize.x / 2 + correctionX / 2, srcSize.y / 2 + correctionY / 2);
            BufferedImage rotatedImage = new BufferedImage(dstSize.x, dstSize.y, src.getType());
            Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
            g.setTransform(affineTransform);
            g.drawImage((Image)src, correctionX / 2, correctionY / 2, null);
            return rotatedImage;
        }

        private static Point rectangleExtendAfterRotation(int width, int height, double d) {
            Point2D.Double center = new Point2D.Double((double)width / 2.0, (double)height / 2.0);
            double degree = Math.toRadians(d);
            Point2D.Double newCorner1 = ImageRotater.rotatedPoint(new Point2D.Double(0.0, 0.0), center, degree);
            Point2D.Double newCorner2 = ImageRotater.rotatedPoint(new Point2D.Double(width, 0.0), center, degree);
            Point2D.Double newCorner3 = ImageRotater.rotatedPoint(new Point2D.Double(width, height), center, degree);
            Point2D.Double newCorner4 = ImageRotater.rotatedPoint(new Point2D.Double(0.0, height), center, degree);
            double minX = Math.min(Math.min(newCorner1.x, newCorner2.x), Math.min(newCorner3.x, newCorner4.x));
            double maxX = Math.max(Math.max(newCorner1.x, newCorner2.x), Math.max(newCorner3.x, newCorner4.x));
            double minY = Math.min(Math.min(newCorner1.y, newCorner2.y), Math.min(newCorner3.y, newCorner4.y));
            double maxY = Math.max(Math.max(newCorner1.y, newCorner2.y), Math.max(newCorner3.y, newCorner4.y));
            return new Point((int)(Math.ceil(maxX) - Math.floor(minX)), (int)(Math.ceil(maxY) - Math.floor(minY)));
        }

        private static Point2D.Double rotatedPoint(Point2D.Double pointToBeRotated, Point2D.Double centerTobeRotatedAround, double degree) {
            double dstAngle = Math.atan2(pointToBeRotated.x - centerTobeRotatedAround.x, pointToBeRotated.y - centerTobeRotatedAround.y) + degree;
            double circleDistance = ImageRotater.distance(centerTobeRotatedAround.x, centerTobeRotatedAround.y, pointToBeRotated.x, pointToBeRotated.y);
            return new Point2D.Double(centerTobeRotatedAround.x + Math.sin(dstAngle) * circleDistance, centerTobeRotatedAround.y + Math.cos(dstAngle) * circleDistance);
        }

        private static double distance(double x1, double y1, double x2, double y2) {
            return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
        }

        public static BufferedImage rotateImageRight(BufferedImage src) {
            return ImageRotater.tiltImage(src, true);
        }

        public static BufferedImage rotateImageLeft(BufferedImage src) {
            return ImageRotater.tiltImage(src, false);
        }

        private static BufferedImage tiltImage(BufferedImage src, boolean clockwise) {
            BufferedImage rotatedImage = new BufferedImage(src.getHeight(), src.getWidth(), src.getType());
            AffineTransform affineTransform = clockwise ? AffineTransform.getRotateInstance(Math.toRadians(90.0), (double)rotatedImage.getWidth() / 2.0, (double)src.getHeight() / 2.0) : AffineTransform.getRotateInstance(Math.toRadians(270.0), (double)src.getWidth() / 2.0, (double)rotatedImage.getHeight() / 2.0);
            Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
            g.setTransform(affineTransform);
            g.drawImage((Image)src, 0, 0, null);
            return rotatedImage;
        }
    }

    private class BorderListener
    implements EventHandler<MouseEvent> {
        private BorderListener() {
        }

        public void handle(MouseEvent event) {
            Button source = (Button)event.getSource();
            boolean isSelected = source.getBorder().equals((Object)EFCPDFBoxThumbNailPane.this.selectedBorder);
            if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED) && !isSelected) {
                source.setBorder(EFCPDFBoxThumbNailPane.this.hoverBorder);
            } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED) && !isSelected) {
                source.setBorder(EFCPDFBoxThumbNailPane.this.emptyBorder);
            }
        }
    }
}

