/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultTable;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultBooleanColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultColumn;
import de.effectivecompany.gui.components.fx.EFCToolBar;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.fx.event.EFCActionExit;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.factory.EFCPrintFactory;
import de.effectivecompany.gui.factory.EFCReportSingleton;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.CSVUtil;
import de.effectivecompany.gui.util.ClipboardUtil;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class EFCTableExportDialog
extends Dialog<Boolean> {
    private EFCTableView<SearchResult> table;
    private EFCToolBar toolBar;
    private final EFCLockPane pin = new EFCLockPane();

    public EFCTableExportDialog(EFCTableView<SearchResult> tModel, SearchService.SearchMetaInfo metaInfo) {
        this.table = new EFCSearchResultTable();
        ObservableList columns = FXCollections.observableArrayList();
        this.table.getItems().addAll((Collection)tModel.getItems());
        for (Object crit : tModel.getColumns()) {
            SearchService.SearchColumnInfo critColInfo;
            if (!(crit instanceof TableColumn)) continue;
            TableColumn critColumn = (TableColumn)crit;
            SearchService.SearchColumnInfo info = null;
            for (SearchService.SearchColumnInfo colInfo : metaInfo.getFields()) {
                if (!colInfo.getName().equalsIgnoreCase(critColumn.getId())) continue;
                info = colInfo;
                break;
            }
            if ((critColInfo = info) == null) continue;
            if (critColInfo.getClazz().isAssignableFrom(EFCBoolean.class)) {
                columns.add((Object)new EFCSearchResultBooleanColumn(critColInfo.getName(), false));
                continue;
            }
            columns.add((Object)new EFCSearchResultColumn(critColInfo));
        }
        this.table.getColumns().addAll((Collection)columns);
        this.table.setEditable(false);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().clearSelection();
        this.toolBar = new EFCToolBar();
        this.toolBar.add(new EFCActionExit(){

            @Override
            public void processAction(String ident, Object context) {
                EFCTableExportDialog.this.dispose();
            }
        });
        this.toolBar.getItems().add((Object)new Separator());
        this.toolBar.add(new PrintDirectAction());
        this.toolBar.add(new ToClipboardAction());
        this.toolBar.add(new ToCSVAction());
        BorderPane rootBorder = new BorderPane();
        rootBorder.setTop((Node)this.toolBar);
        rootBorder.setCenter(this.table);
        StackPane root = new StackPane();
        root.getChildren().addAll((Object[])new Node[]{rootBorder, this.pin});
        this.getDialogPane().setContent((Node)root);
        this.initModality(Modality.WINDOW_MODAL);
        this.getDialogPane().setPrefHeight(400.0);
        this.getDialogPane().setPrefWidth(600.0);
        this.setResizable(true);
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> this.dispose());
        window.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                this.dispose();
            }
        });
        ((Stage)window).getIcons().add((Object)EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_FX);
        this.setTitle(Translator.tr((String)"DLG_TITLE_DATAEXPORT"));
        this.resultProperty().set((Object)true);
    }

    private void dispose() {
        this.table.getSelectionModel().setCellSelectionEnabled(false);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.close();
    }

    private class PrintDirectAction
    extends EFCAbstractAction {
        private final String IDENT = "direct_print";

        public PrintDirectAction() {
            super(Translator.tr((String)"ACTION_PRINT_DIRECT"), EFCLookAndFeelManager.ICON_TOOLBAR_PRINT_DIRECT_FX);
            this.IDENT = "direct_print";
            this.setLongText(Translator.tr((String)"ACTION_PRINT_DIRECT_DESC"));
            this.setEventHandler(handler -> {
                EFCTableExportDialog.this.pin.setVisible(true);
                Task<EFCReportContainer> task = new Task<EFCReportContainer>(){

                    protected EFCReportContainer call() throws Exception {
                        return EFCReportSingleton.getInstance().buildReport(EFCTableExportDialog.this.table);
                    }
                };
                task.setOnFailed(taskHandler -> {
                    EFCTableExportDialog.this.pin.setVisible(false);
                    EFCDesktop.getInstance();
                    EFCDesktop.reportError(taskHandler.getSource().getException());
                });
                task.setOnSucceeded(taskHandler -> {
                    EFCReportContainer efcReportContainer = (EFCReportContainer)taskHandler.getSource().getValue();
                    EFCTableExportDialog.this.pin.setVisible(false);
                    Boolean selection = EFCDesktop.showYesNoCancelDialog(Translator.tr((String)"MSG_FRAME_OPTIONDLG_PRINTPREVIEW_TITLE"), "", Translator.tr((String)"MSG_FRAME_OPTIONDLG_PRINTPREVIEW_QUESTION"));
                    if (selection != null) {
                        if (selection.booleanValue()) {
                            EFCThreadUtil.doLater(() -> {
                                EFCPDFViewer viewer = new EFCPDFViewer(efcReportContainer, "Direkt Druck");
                                EFCDesktop.getInstance().add(viewer);
                            });
                            EFCTableExportDialog.this.dispose();
                        } else {
                            EFCThreadUtil.doLater(() -> new EFCPrintFactory().print(efcReportContainer));
                        }
                    }
                });
                EFCThreadUtil.getCachedExecutorService().execute((Runnable)task);
            });
        }

        @Override
        public String getIdent() {
            return "direct_print";
        }
    }

    private class ToCSVAction
    extends EFCAbstractAction {
        private final String IDENT = "table_to_csv";

        public ToCSVAction() {
            super(Translator.tr((String)"ACTION_TABLE_TO_CSV"), EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_HD_FX);
            this.IDENT = "table_to_csv";
            this.setLongText(Translator.tr((String)"ACTION_TABLE_TO_CSV_DESC"));
            this.setEventHandler(eventHandler -> {
                String csv = CSVUtil.tableToCSVFX(EFCTableExportDialog.this.table);
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV-File (*.csv)", new String[]{".csv"}));
                File target = fileChooser.showSaveDialog(null);
                if (target != null) {
                    if (!target.getName().endsWith(".csv")) {
                        target = new File(target.getPath() + ".csv");
                    }
                    try {
                        FileWriter writer = new FileWriter(target);
                        writer.write(csv);
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }

        @Override
        public String getIdent() {
            return "table_to_csv";
        }
    }

    private class ToClipboardAction
    extends EFCAbstractAction {
        private final String IDENT = "table_to_clipboard";

        public ToClipboardAction() {
            super(Translator.tr((String)"ACTION_TABLE_TO_CLIPBOARD"), EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_CB_FX);
            this.IDENT = "table_to_clipboard";
            this.setLongText(Translator.tr((String)"ACTION_TABLE_TO_CLIPBOARD_DESC"));
            this.setEventHandler(eventHandler -> ClipboardUtil.tableToClipboardFX(EFCTableExportDialog.this.table));
        }

        @Override
        public String getIdent() {
            return "table_to_clipboard";
        }
    }
}

