/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.chart;

import de.effectivecompany.gui.components.fx.chart.DateAxis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;

public class EFCGanttChart<X, Y>
extends XYChart<X, Y> {
    private double blockHeight = 10.0;

    public EFCGanttChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public EFCGanttChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        if (!(xAxis instanceof DateAxis) || !(yAxis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, X and Y should both be NumberAxis");
        }
        this.setData(data);
    }

    private static String getStyleClass(Object obj) {
        return ((ExtraData)obj).getStyleClass();
    }

    private static long getLength(Object obj) {
        return ((ExtraData)obj).getLength();
    }

    private static String getText(Object obj) {
        return ((ExtraData)obj).getText();
    }

    protected void layoutPlotChildren() {
        for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator iter = this.getDisplayedDataIterator(series);
            while (iter.hasNext()) {
                Rectangle ellipse;
                Node block;
                XYChart.Data item = (XYChart.Data)iter.next();
                double x = this.getXAxis().getDisplayPosition(item.getXValue());
                double y = this.getYAxis().getDisplayPosition(item.getYValue());
                if (Double.isNaN(x) || Double.isNaN(y) || (block = item.getNode()) == null || !(block instanceof StackPane)) continue;
                StackPane region = (StackPane)item.getNode();
                if (region.getShape() == null) {
                    ellipse = new Rectangle((double)EFCGanttChart.getLength(item.getExtraValue()), this.getBlockHeight());
                } else if (region.getShape() instanceof Rectangle) {
                    ellipse = (Rectangle)region.getShape();
                } else {
                    return;
                }
                ellipse.setWidth((double)EFCGanttChart.getLength(item.getExtraValue()) * (this.getXAxis() instanceof DateAxis ? Math.abs(((DateAxis)this.getXAxis()).getScale()) : 1.0));
                ellipse.setHeight(this.getBlockHeight() * (this.getYAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getYAxis()).getScale()) : 1.0));
                y -= this.getBlockHeight() / 2.0;
                region.setShape(null);
                region.setShape((Shape)ellipse);
                region.setScaleShape(false);
                region.setCenterShape(false);
                region.setCacheShape(false);
                region.setLayoutX(x);
                region.setLayoutY(y);
            }
        }
    }

    public double getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(double blockHeight) {
        this.blockHeight = blockHeight;
    }

    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        Node block = this.createContainer(series, this.getData().indexOf(series), item, itemIndex);
        this.getPlotChildren().add((Object)block);
    }

    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node block = item.getNode();
        this.getPlotChildren().remove((Object)block);
        this.removeDataItemFromDisplay(series, item);
    }

    protected void dataItemChanged(XYChart.Data<X, Y> item) {
    }

    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node container = this.createContainer(series, seriesIndex, item, j);
            this.getPlotChildren().add((Object)container);
        }
        this.updateAxisRange();
    }

    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        for (XYChart.Data d : series.getData()) {
            Node container = d.getNode();
            this.getPlotChildren().remove((Object)container);
        }
        this.removeSeriesFromDisplay(series);
    }

    private Node createContainer(XYChart.Series<X, Y> series, int seriesIndex, XYChart.Data<X, Y> item, int itemIndex) {
        Node container = item.getNode();
        if (container == null) {
            container = new StackPane();
            Text text = new Text(EFCGanttChart.getText(item.getExtraValue()));
            ((StackPane)container).getChildren().add((Object)text);
            item.setNode(container);
        }
        container.getStyleClass().add((Object)EFCGanttChart.getStyleClass(item.getExtraValue()));
        return container;
    }

    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList<Object> xData = null;
        ArrayList<Object> yData = null;
        xData = new ArrayList<Object>();
        yData = new ArrayList<Object>();
        if (xData != null || yData != null) {
            for (Object series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        xData.add(data.getXValue());
                        xData.add(xa.toRealValue(xa.toNumericValue(data.getXValue()) + (double)EFCGanttChart.getLength(data.getExtraValue())));
                    }
                    if (yData == null || yData.contains(data.getYValue())) continue;
                    yData.add(data.getYValue());
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ArrayList<String> categoryNames = new ArrayList<String>();
                categoryNames.addAll((Collection<String>)((CategoryAxis)ya).getCategories());
                for (String cat : ((CategoryAxis)ya).getCategories()) {
                    if (yData.contains(cat)) continue;
                    categoryNames.remove(cat);
                }
                for (int i = 0; i < yData.size(); ++i) {
                    int len = categoryNames.size();
                    if (categoryNames.contains(yData.get(i))) continue;
                    categoryNames.add(i > len ? len : i, yData.get(i).toString());
                }
                ((CategoryAxis)ya).getCategories().clear();
                ((CategoryAxis)ya).getCategories().addAll(categoryNames);
            }
        }
    }

    public static class ExtraData {
        public long length;
        public String styleClass;
        public String text;

        public ExtraData(long lengthMs, String styleClass, String text) {
            this.length = lengthMs;
            this.styleClass = styleClass;
            this.text = text;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

