/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.chart;

import de.effectivecompany.gui.components.fx.chart.DateAxis;
import de.effectivecompany.gui.components.fx.chart.EFCGanttChart;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class EFCGanttChartPane
extends JFXPanel {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DateAxis xAxis = new DateAxis();
    private final CategoryAxis yAxis = new CategoryAxis();
    private EFCGanttChart<Date, String> gantt;

    public EFCGanttChartPane() {
        this.yAxis.setAutoRanging(false);
        this.xAxis.setAutoRanging(false);
        this.xAxis.setUpperBound(new Date(150, 11, 9));
        this.xAxis.setLowerBound(new Date(105, 11, 9));
        this.gantt = new EFCGanttChart(this.xAxis, this.yAxis);
        this.gantt.setOnScroll(s -> {
            Double newValueUpper;
            Double newValueLower;
            Double numericValueLower = this.xAxis.toNumericValue(this.xAxis.getLowerBound());
            Double numericValueUpper = this.xAxis.toNumericValue(this.xAxis.getUpperBound());
            Double erg = (numericValueUpper - numericValueLower) / 16.0;
            double deltaY = s.getDeltaY();
            if (deltaY > 0.0) {
                newValueLower = numericValueLower + erg;
                newValueUpper = numericValueUpper - erg;
            } else {
                newValueLower = numericValueLower - erg;
                newValueUpper = numericValueUpper + erg;
            }
            Double percentageZoom = (s.getX() - this.gantt.getWidth() / 2.0) / (this.gantt.getWidth() / 2.0);
            Double diffNewOld = newValueLower - numericValueLower;
            newValueLower = newValueLower + diffNewOld * percentageZoom;
            newValueUpper = newValueUpper + diffNewOld * percentageZoom;
            Date newLowerBound = this.xAxis.toRealValue(newValueLower);
            Date newUpperBound = this.xAxis.toRealValue(newValueUpper);
            if (newLowerBound.compareTo(newUpperBound) < 0) {
                this.xAxis.setLowerBound(newLowerBound);
                this.xAxis.setUpperBound(newUpperBound);
            }
        });
        this.gantt.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("ganttchart.css").toExternalForm());
        double SCALE_DELTA = 1.1;
        StackPane chartContainer = new StackPane();
        chartContainer.getChildren().add(this.gantt);
        Rectangle zoomRect = new Rectangle();
        zoomRect.setManaged(false);
        zoomRect.setFill((Paint)Color.LIGHTSEAGREEN.deriveColor(0.0, 1.0, 1.0, 0.5));
        this.setScene(new Scene((Parent)chartContainer));
    }

    public EFCGanttChart getGantt() {
        return this.gantt;
    }

    public void setGantt(EFCGanttChart gantt) {
        this.gantt = gantt;
    }

    public DateAxis getxAxis() {
        return this.xAxis;
    }

    public Double bfdg(double v) {
        return v;
    }

    public CategoryAxis getyAxis() {
        return this.yAxis;
    }
}

