/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.dialog;

import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.dialog.EFCStartServerShutdownReminderDialogResult;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import jfxtras.scene.control.LocalDateTimeTextField;

public class EFCStartServerShutdownReminderDialog
extends Dialog<EFCStartServerShutdownReminderDialogResult> {
    private final SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);

    public EFCStartServerShutdownReminderDialog() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle(Translator.tr((String)"DLG_TITLE_SHUTDOWN_MSG"));
        ButtonType sendButtonType = new ButtonType(Translator.tr((String)"_SEND"), ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType(Translator.tr((String)"_CLOSE"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{sendButtonType, cancelButtonType});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        TextArea textMessage = new TextArea();
        grid.add((Node)new Label(Translator.tr((String)"LABEL_TXT_MSG")), 0, 0);
        grid.add((Node)textMessage, 1, 0);
        grid.add((Node)new Label(Translator.tr((String)"LABEL_SERVERRESTART_DATE")), 0, 2);
        LocalDateTimeTextField datePicker = new LocalDateTimeTextField();
        datePicker.setDateTimeFormatter(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"));
        datePicker.setLocalDateTime(LocalDateTime.now().plusMinutes(10L));
        grid.add((Node)datePicker, 1, 2);
        Button sendButton = (Button)this.getDialogPane().lookupButton(sendButtonType);
        sendButton.addEventFilter(ActionEvent.ACTION, event -> {
            Task<Void> messageTask = this.createTask(new EFCStartServerShutdownReminderDialogResult(Date.from(datePicker.getLocalDateTime().atZone(ZoneId.systemDefault()).toInstant()), textMessage.getText()));
            messageTask.setOnFailed(e -> EFCDesktop.reportError((Throwable)e.getSource().exceptionProperty().get()));
            EFCThreadUtil.getCachedExecutorService().submit((Runnable)messageTask);
            event.consume();
        });
        datePicker.textProperty().addListener((observable, oldValue, newValue) -> sendButton.setDisable(newValue.trim().isEmpty()));
        sendButton.setDisable(true);
        this.getDialogPane().setContent((Node)grid);
        this.setResultConverter(dialogButton -> {
            if (dialogButton == sendButtonType) {
                return new EFCStartServerShutdownReminderDialogResult(Date.from(datePicker.getLocalDateTime().atZone(ZoneId.systemDefault()).toInstant()), textMessage.getText());
            }
            return null;
        });
        Region spacer = new Region();
        ButtonBar.setButtonData((Node)spacer, (ButtonBar.ButtonData)ButtonBar.ButtonData.BIG_GAP);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.getDialogPane().applyCss();
        HBox hbox = (HBox)this.getDialogPane().lookup(".container");
        hbox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        hbox.getChildren().add((Object)spacer);
        this.showAndWait();
    }

    private Task<Void> createTask(final EFCStartServerShutdownReminderDialogResult result) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    EFCStartServerShutdownReminderDialog.this.svSysApp.startDcShutdownReminder(result.getShutdown(), result.getMessage());
                }
                catch (Exception e) {
                    EFCDesktop.reportError(e);
                }
                return null;
            }
        };
    }
}

