/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.dialog;

import de.effectivecompany.app.app.OpSys_TextMsgTargetType;
import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.app.sst.SoLiSysUsrBas;
import de.effectivecompany.app.sst.service.SvSoSys;
import de.effectivecompany.app.sys.DcSoLiSysUsrBas;
import de.effectivecompany.app.sys.DcSysTextMsg;
import de.effectivecompany.app.sys.service.SvSysMsgBus;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.dialog.TextMessageDialogResult;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.EFCSelectionListView;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCTextMessageDialog
extends Dialog<TextMessageDialogResult> {
    private final SvSysMsgBus svSysMsgBus = (SvSysMsgBus)SpringHelper.getService(SvSysMsgBus.class);
    private final SvSoSys svSoSys = (SvSoSys)SpringHelper.getService(SvSoSys.class);
    private final SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
    private static Logger logger = LoggerFactory.getLogger(EFCTextMessageDialog.class);
    private ExecutorService exec = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });

    public EFCTextMessageDialog() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle(Translator.tr((String)"DLG_TITLE_TXT_MSG"));
        ButtonType sendButtonType = new ButtonType(Translator.tr((String)"_SEND"), ButtonBar.ButtonData.OK_DONE);
        ButtonType cancel = new ButtonType(Translator.tr((String)"_CLOSE"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{sendButtonType, cancel});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        StackPane usersPane = new StackPane();
        EFCSelectionListView users = new EFCSelectionListView(false);
        EFCLockPane pin = new EFCLockPane();
        usersPane.getChildren().addAll((Object[])new Node[]{users, pin});
        pin.setVisible(true);
        Task<EFCList<SoLiSysUsrBas>> task = this.createTask();
        task.setOnSucceeded(event -> {
            if (users != null) {
                users.getItems().clear();
                if (event.getSource().valueProperty().get() != null) {
                    ObservableList ob = FXCollections.observableArrayList((Collection)((EFCList)event.getSource().valueProperty().get()));
                    users.setItems(ob);
                }
            }
            pin.setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            pin.setVisible(false);
            if (taskEvent.getSource().exceptionProperty().get() != null) {
                EFCDesktop.reportError((Throwable)taskEvent.getSource().exceptionProperty().get());
            }
        });
        this.exec.submit((Runnable)task);
        TextArea textMessage = new TextArea();
        CheckBox stickyCheckBox = new CheckBox(Translator.tr((String)"LABEL_TXT_MSG_STICKY"));
        ComboBox comboBox = new ComboBox();
        comboBox.setItems(FXCollections.observableArrayList(OpSys_TextMsgTargetType.getValues().values()));
        comboBox.valueProperty().addListener((obs, oldval, newval) -> {});
        comboBox.setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer object) {
                if (object != null) {
                    return Translator.tr((String)("OPT_" + OpSys_TextMsgTargetType.class.getSimpleName().toUpperCase() + "_" + (String)OpSys_TextMsgTargetType.getValues().entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(object)).findFirst().get().getKey())).toUpperCase();
                }
                return null;
            }

            public Integer fromString(String string) {
                if (string != null) {
                    return (Integer)OpSys_TextMsgTargetType.getValues().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(string)).findFirst().get().getValue();
                }
                return null;
            }
        });
        comboBox.setCellFactory((Callback)new Callback<ListView<Integer>, ListCell<Integer>>(){

            public ListCell<Integer> call(ListView<Integer> param) {
                return new ListCell<Integer>(){

                    protected void updateItem(Integer t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(Translator.tr((String)("OPT_" + OpSys_TextMsgTargetType.class.getSimpleName().toUpperCase() + "_" + (String)OpSys_TextMsgTargetType.getValues().entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(t)).findFirst().get().getKey())));
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
        comboBox.getSelectionModel().select(0);
        grid.add((Node)new Label(Translator.tr((String)"LABEL_TXT_MSG")), 0, 0);
        grid.add((Node)textMessage, 1, 0);
        grid.add((Node)new Label(""), 0, 1);
        grid.add((Node)stickyCheckBox, 1, 1);
        grid.add((Node)new Label(Translator.tr((String)"LABEL_TXT_MSG_TARGET")), 0, 2);
        grid.add((Node)comboBox, 1, 2);
        grid.add((Node)new Label(Translator.tr((String)"LABEL_TXT_MSG_USER")), 0, 3);
        grid.add((Node)usersPane, 1, 3);
        Button sendButton = (Button)this.getDialogPane().lookupButton(sendButtonType);
        sendButton.addEventFilter(ActionEvent.ACTION, event -> {
            Task<Void> messageTask = this.createTask(new TextMessageDialogResult(users.getSelected(), textMessage.getText(), !stickyCheckBox.isSelected(), (Integer)comboBox.getValue()));
            messageTask.setOnFailed(e -> EFCDesktop.reportError((Throwable)e.getSource().exceptionProperty().get()));
            this.exec.submit((Runnable)messageTask);
            event.consume();
        });
        sendButton.setDisable(true);
        textMessage.textProperty().addListener((observable, oldValue, newValue) -> sendButton.setDisable(newValue.trim().isEmpty()));
        this.getDialogPane().setContent((Node)grid);
        this.setResultConverter(dialogButton -> {
            if (dialogButton == sendButtonType) {
                return new TextMessageDialogResult(users.getSelected(), textMessage.getText(), !stickyCheckBox.isSelected(), (Integer)comboBox.getValue());
            }
            return null;
        });
        Region spacer = new Region();
        ButtonBar.setButtonData((Node)spacer, (ButtonBar.ButtonData)ButtonBar.ButtonData.BIG_GAP);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.getDialogPane().applyCss();
        HBox hbox = (HBox)this.getDialogPane().lookup(".container");
        hbox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        hbox.getChildren().add((Object)spacer);
        this.showAndWait();
    }

    private Task<Void> createTask(final TextMessageDialogResult result) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                DcSysTextMsg msg = EFCTextMessageDialog.this.svSysMsgBus.newDcSysTextMsg();
                result.getUsers().forEach(user -> {
                    DcSoLiSysUsrBas dcSoLiSysUsrBas = new DcSoLiSysUsrBas();
                    dcSoLiSysUsrBas.setIsselected(Boolean.valueOf(true));
                    dcSoLiSysUsrBas.setUsername(user.getUsername());
                    dcSoLiSysUsrBas.setPername1(user.getPername1());
                    dcSoLiSysUsrBas.setPername2(user.getPername2());
                    msg.getRecipients().add((Object)dcSoLiSysUsrBas);
                });
                msg.setText(result.getMessage());
                msg.setSticky(Boolean.valueOf(result.isSticky()));
                msg.setSystextmsgtarget(result.getTextMsgTarget());
                try {
                    EFCTextMessageDialog.this.svSysMsgBus.sendDcSysTextMsg(msg);
                }
                catch (Exception e) {
                    EFCDesktop.reportError(e);
                }
                return null;
            }
        };
    }

    private Task<EFCList<SoLiSysUsrBas>> createTask() {
        return new Task<EFCList<SoLiSysUsrBas>>(){

            protected EFCList<SoLiSysUsrBas> call() throws Exception {
                try {
                    return EFCTextMessageDialog.this.svSoSys.getListSysUsrBas();
                }
                catch (Exception e) {
                    logger.error(e.getStackTrace().toString());
                    return null;
                }
            }
        };
    }
}

