/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.sst.SoLiSysUsrBas;
import de.effectivecompany.app.sys.MdSysUsrBas;
import de.effectivecompany.app.syscl.ClSysUsrWflGrp;
import de.effectivecompany.gui.components.fx.EFCEventUtil;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class EFCSelectionListView<T>
extends ListView<T> {
    public EFCSelectionListView(final boolean selectionDisabled) {
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        EventHandler eventHandler = event -> {
            if (!event.isShortcutDown()) {
                Event.fireEvent((EventTarget)event.getTarget(), (Event)EFCEventUtil.cloneMouseEvent(event));
                event.consume();
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, eventHandler);
        if (selectionDisabled) {
            EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    event.consume();
                }
            };
            this.addEventFilter(KeyEvent.ANY, (EventHandler)keyHandler);
        }
        this.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> p) {
                ListCell cell = new ListCell<T>(){

                    protected void updateItem(T t, boolean bln) {
                        super.updateItem(t, bln);
                        if (t != null) {
                            if (t instanceof SoLiSysUsrBas) {
                                SoLiSysUsrBas user = (SoLiSysUsrBas)t;
                                Object text = "";
                                if (user.getPername1().getData() != null) {
                                    text = user.getPername1().getData();
                                    text = (String)text + (String)(user.getPername2().getData() != null && !user.getPername2().getData().isEmpty() ? " - " + user.getPername2().getData() : "");
                                } else {
                                    text = user.getUsername().getData();
                                }
                                this.setText((String)text);
                                return;
                            }
                            if (t instanceof MdSysUsrBas) {
                                MdSysUsrBas user = (MdSysUsrBas)t;
                                Object text = "";
                                if (user.getPername1().getData() != null) {
                                    text = user.getPername1().getData();
                                    text = (String)text + (String)(user.getPername2().getData() != null && !user.getPername2().getData().isEmpty() ? " - " + user.getPername2().getData() : "");
                                } else {
                                    text = user.getUsername().getData();
                                }
                                this.setText((String)text);
                                return;
                            }
                            if (t instanceof ClSysUsrWflGrp) {
                                ClSysUsrWflGrp grp = (ClSysUsrWflGrp)t;
                                Object text = "";
                                text = grp.getUserwflgrp().getData();
                                text = (String)text + (String)(grp.getStext().getData() != null && !grp.getStext().getData().isEmpty() ? " - " + grp.getStext().getData() : "");
                                this.setText((String)text);
                                return;
                            }
                            this.setText(t.toString());
                        } else {
                            this.setText("");
                        }
                    }
                };
                cell.setMouseTransparent(selectionDisabled);
                return cell;
            }
        });
    }

    public List<T> getSelected() {
        return this.getSelectionModel().getSelectedItems();
    }
}

