/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflFormValue;
import de.effectivecompany.app.syswfl.BoWflProcDefEntry;
import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.wfl.EFCWflTitledPane;
import de.effectivecompany.gui.components.fx.wfl.WflAccordion;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;

public class EFCWflAvailableProcPane
extends WflAccordion {
    private final Map<String, Property<?>> model = new HashMap();

    public EFCWflAvailableProcPane(WflController controller) {
        super(Translator.tr((String)"WFL_AVAILABLE_PROCS"), WflPanelType.PROCESSES_LIST);
    }

    public void setAvailableProcs(List<BoWflProcDefEntry> procList) {
        this.model.clear();
        this.clear();
        for (int i = 0; i < procList.size(); ++i) {
            BoWflProcDefEntry procDef = procList.get(i);
            GridPane gridpane = new GridPane();
            gridpane.setPadding(new Insets(5.0));
            gridpane.setHgap(5.0);
            gridpane.setVgap(5.0);
            Label description = new Label();
            description.setText(procDef.getAct_description().toString());
            description.setWrapText(true);
            description.setPrefHeight(50.0);
            gridpane.add((Node)description, 0, 0, 2, 1);
            int row = 1;
            for (BoWflVariable var : procDef.getStartVariables()) {
                Label label = new Label(Translator.tr((String)("FLD_" + var.getAct_name().toString().toUpperCase())));
                String toolTip = Translator.tr((String)("FLD_" + var.getAct_name().toString().toUpperCase() + "_DESC"));
                if (toolTip != null && !toolTip.isEmpty()) {
                    Tooltip tool = new Tooltip(toolTip);
                    tool.getStyleClass().add((Object)"ttip");
                    label.setTooltip(tool);
                }
                label.setPrefWidth(75.0);
                gridpane.add((Node)label, 0, row);
                switch (var.getAct_type().getData()) {
                    case 0: {
                        TextField input = new TextField();
                        input.setDisable(var.getAct_isWritable().getBoolean() == false);
                        if (var.getAct_value() != null && var.getAct_value().getData() != null) {
                            input.setText(var.getAct_value().getData());
                        }
                        this.model.put(procDef.getAct_id().toString() + var.getAct_id().toString(), (Property<?>)input.textProperty());
                        input.setPrefWidth(100.0);
                        gridpane.add((Node)input, 1, row);
                        break;
                    }
                    case 30: {
                        CheckBox cbox = new CheckBox();
                        cbox.setDisable(var.getAct_isWritable().getBoolean() == false);
                        this.model.put(procDef.getAct_id().toString() + var.getAct_id().toString(), (Property<?>)cbox.selectedProperty());
                        gridpane.add((Node)cbox, 1, row);
                    }
                }
                ++row;
            }
            Button start = new Button(Translator.tr((String)"WFL_START_PROC"));
            start.setId(procDef.getAct_id().toString());
            Label errorMsg = new Label();
            errorMsg.setWrapText(true);
            errorMsg.setPrefHeight(30.0);
            start.setOnAction(event -> {
                EFCMap vars = new EFCMap();
                Button src = (Button)event.getSource();
                for (String v : this.model.keySet()) {
                    if (!v.startsWith(src.getId())) continue;
                    Object value = this.model.get(v).getValue();
                    if (value instanceof BoWflFormValue) {
                        value = ((BoWflFormValue)value).getId();
                    }
                    if (value.toString() == null || value.toString().isEmpty()) continue;
                    vars.put((Object)new EFCString(v.replace(src.getId(), "")), (Object)new EFCString(value.toString()));
                }
                WflController.getInstance().startProcess(src.getId(), (EFCMap<EFCString, EFCString>)vars, errorMsg);
            });
            gridpane.add((Node)start, 0, row, 2, 1);
            gridpane.add((Node)errorMsg, 0, row + 1, 2, 1);
            EFCWflTitledPane titledPane = new EFCWflTitledPane(procDef.getAct_name().getData());
            titledPane.setMaxWidth(500.0);
            titledPane.setMinWidth(500.0);
            this.add(titledPane);
        }
    }
}

