/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.sys.MdSysUsrBas;
import de.effectivecompany.app.syscl.ClSysUsrWflGrp;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.EFCDateTimePicker;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.EFCSelectionListView;
import de.effectivecompany.gui.components.fx.wfl.EFCTextArea;
import de.effectivecompany.gui.components.fx.wfl.EFCTextField;
import de.effectivecompany.gui.components.fx.wfl.EFCWflButton;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.fx.wfl.service.WflAssigneeComboBox;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class EFCWflCreateTaskPane
extends StackPane {
    private final EFCLockPane pin = new EFCLockPane();

    public EFCWflCreateTaskPane(WflController controller, boolean forAdmin) {
        BorderPane border = new BorderPane();
        final Button ok = new Button(Translator.tr((String)"_OK"));
        ok.setDisable(true);
        HBox root = new HBox(5.0);
        root.setAlignment(Pos.CENTER_LEFT);
        root.setPadding(new Insets(5.0));
        EFCWflButton hideButton = new EFCWflButton(EFCLookAndFeelManager.ICON_WFL_HIDE);
        root.getChildren().add((Object)hideButton);
        hideButton.setOnAction(event -> controller.showView(WflPanelType.EMPTY, false));
        Label text = new Label(Translator.tr((String)"WFL_CREATETASK"));
        text.setContentDisplay(ContentDisplay.CENTER);
        root.getChildren().add((Object)text);
        border.setTop((Node)root);
        GridPane gridpane = new GridPane();
        gridpane.setPadding(new Insets(5.0));
        gridpane.setHgap(5.0);
        gridpane.setVgap(5.0);
        Label nameLabel = new Label(Translator.tr((String)"LABEL_ACT_TASKNAME"));
        EFCTextField name = new EFCTextField(255);
        Label descriptionLabel = new Label(Translator.tr((String)"LABEL_ACT_DESCRIPTION"));
        EFCTextArea description = new EFCTextArea(4000);
        description.setWrapText(true);
        description.setPrefHeight(150.0);
        Label dueDateLabel = new Label(Translator.tr((String)"LABEL_DUEDATE"));
        EFCDateTimePicker dueDate = new EFCDateTimePicker();
        ComboBox priority = new ComboBox();
        priority.setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer object) {
                String text = "";
                if (object != null) {
                    switch (object) {
                        default: {
                            text = Translator.tr((String)"WFL_PRIO_STANDARD");
                            break;
                        }
                        case 5: {
                            text = Translator.tr((String)"WFL_PRIO_HIGH");
                            break;
                        }
                        case 10: {
                            text = Translator.tr((String)"WFL_PRIO_VERYHIGH");
                        }
                    }
                }
                return text;
            }

            public Integer fromString(String string) {
                return null;
            }
        });
        priority.getItems().addAll((Object[])new Integer[]{1, 5, 10});
        final WflAssigneeComboBox assignee = new WflAssigneeComboBox();
        Label candidateUsersLabel = new Label(Translator.tr((String)"LABEL_ACT_CANDIDATEUSERS"));
        final EFCSelectionListView<MdSysUsrBas> candidateUsers = new EFCSelectionListView<MdSysUsrBas>(false);
        final EFCSelectionListView<ClSysUsrWflGrp> candidateWflGroups = new EFCSelectionListView<ClSysUsrWflGrp>(false);
        candidateUsers.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<MdSysUsrBas>(){

            public void onChanged(ListChangeListener.Change<? extends MdSysUsrBas> c) {
                if (c.getList().size() > 0) {
                    assignee.getAssignee().setValue(null);
                    assignee.getAssignee().setDisable(true);
                    ok.setDisable(false);
                } else if (candidateWflGroups.getSelectionModel().getSelectedItems().size() == 0) {
                    assignee.getAssignee().setDisable(false);
                    ok.setDisable(true);
                }
            }
        });
        candidateUsers.setPrefHeight(150.0);
        StackPane candidateUsersPane = new StackPane();
        EFCLockPane candidateUsersPin = new EFCLockPane();
        candidateUsersPane.getChildren().addAll((Object[])new Node[]{candidateUsers, candidateUsersPin});
        Label candidateWflGroupsLabel = new Label(Translator.tr((String)"LABEL_ACT_CANDIDATEGROUPS"));
        candidateWflGroups.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<ClSysUsrWflGrp>(){

            public void onChanged(ListChangeListener.Change<? extends ClSysUsrWflGrp> c) {
                if (c.getList().size() > 0) {
                    assignee.getAssignee().setValue(null);
                    assignee.getAssignee().setDisable(true);
                    ok.setDisable(false);
                } else if (candidateUsers.getSelectionModel().getSelectedItems().size() == 0) {
                    assignee.getAssignee().setDisable(false);
                    ok.setDisable(true);
                }
            }
        });
        candidateWflGroups.setPrefHeight(150.0);
        StackPane candidateWflGroupsPane = new StackPane();
        EFCLockPane candidateWflGroupsPin = new EFCLockPane();
        candidateWflGroupsPane.getChildren().addAll((Object[])new Node[]{candidateWflGroups, candidateWflGroupsPin});
        Label assigneeLabel = new Label(Translator.tr((String)"FLD_ACT_ASSIGNEE"));
        Label priorityLabel = new Label(Translator.tr((String)"FLD_ACT_PRIORITY"));
        assignee.getAssignee().valueProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                if (newValue != null) {
                    candidateWflGroups.setDisable(true);
                    candidateUsers.setDisable(true);
                    ok.setDisable(false);
                } else {
                    candidateWflGroups.setDisable(false);
                    candidateUsers.setDisable(false);
                    ok.setDisable(true);
                }
            }
        });
        StackPane assigneePane = new StackPane();
        EFCLockPane assigneePin = new EFCLockPane();
        assigneePane.setAlignment(Pos.TOP_LEFT);
        assigneePane.getChildren().addAll((Object[])new Node[]{assignee});
        gridpane.add((Node)nameLabel, 0, 0);
        gridpane.add((Node)name, 1, 0);
        gridpane.add((Node)descriptionLabel, 0, 1);
        gridpane.add((Node)description, 1, 1);
        gridpane.add((Node)dueDateLabel, 0, 2);
        gridpane.add((Node)dueDate, 1, 2);
        gridpane.add((Node)priorityLabel, 0, 3);
        gridpane.add((Node)priority, 1, 3);
        gridpane.add((Node)assigneeLabel, 0, 4);
        gridpane.add((Node)assigneePane, 1, 4);
        gridpane.add((Node)candidateUsersLabel, 0, 5);
        gridpane.add((Node)candidateUsersPane, 1, 5);
        gridpane.add((Node)candidateWflGroupsLabel, 0, 6);
        gridpane.add((Node)candidateWflGroupsPane, 1, 6);
        gridpane.setAlignment(Pos.TOP_LEFT);
        FlowPane buttons = new FlowPane(Orientation.HORIZONTAL);
        buttons.setHgap(10.0);
        Button cancel = new Button(Translator.tr((String)"_CANCEL"));
        Label errorMsg = new Label();
        errorMsg.setWrapText(true);
        errorMsg.setPrefHeight(30.0);
        cancel.setOnAction(event -> controller.showView(WflPanelType.EMPTY, forAdmin));
        ok.setOnAction(event -> {
            if (name.getText() != null && !name.getText().trim().isEmpty()) {
                EFCString taskName = new EFCString(name.getText());
                EFCText taskDescription = new EFCText(description.getText());
                List userWflGrps = candidateWflGroups.getSelected().stream().map(ClSysUsrWflGrp::getUserwflgrp).collect(Collectors.toList());
                List candidateUserList = candidateUsers.getSelected().stream().map(MdSysUsrBas::getUsername).collect(Collectors.toList());
                controller.createTask(taskName, taskDescription, dueDate.getEFCDateTime(), (EFCList<EFCString>)new EFCList(candidateUserList), (EFCList<EFCString>)new EFCList(userWflGrps), assignee.getAssignee().getSelected(), (Integer)priority.getSelectionModel().getSelectedItem(), errorMsg);
            }
        });
        buttons.getChildren().add((Object)ok);
        buttons.getChildren().add((Object)cancel);
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
        vbox.getChildren().addAll((Object[])new Node[]{gridpane, errorMsg, buttons});
        ScrollPane scroll = new ScrollPane((Node)vbox);
        border.setCenter((Node)scroll);
        this.getChildren().addAll((Object[])new Node[]{border, this.pin});
        controller.getUsers(candidateUsers, candidateUsersPin);
        controller.getWflGroups(candidateWflGroups, candidateWflGroupsPin);
    }

    public void setWorking(boolean isWorking) {
        this.pin.setVisible(isWorking);
    }
}

