/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syscl.ClSysWflParamDet;
import de.effectivecompany.app.syswfl.BoWflExecution;
import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.wfl.EFCWflProgButton;
import de.effectivecompany.gui.components.fx.wfl.EFCWflTitledPane;
import de.effectivecompany.gui.components.fx.wfl.WflAccordion;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.root.EFCNavigator;
import de.effectivecompany.gui.constants.EFCParamConstants;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class EFCWflMyProcListPane
extends WflAccordion {
    public EFCWflMyProcListPane(WflController controller, boolean isAdmin) {
        super(Translator.tr((String)"WFL_MY_PROCS"), WflPanelType.PROCESSES_LIST);
    }

    public void setMyProcs(List<BoWflExecution> procList) {
        this.clear();
        for (int i = 0; i < procList.size(); ++i) {
            BoWflExecution proc = procList.get(i);
            BoWflVariable progkey = (BoWflVariable)proc.getAct_variables().get((Object)EFCParamConstants.WFL_CONST_PROGKEY);
            EFCList paramList = new EFCList();
            if (progkey != null && progkey.getAct_value() != null && WflController.getInstance().getWflParams().get((Object)progkey.getAct_value()) != null) {
                paramList = (EFCList)WflController.getInstance().getWflParams().get((Object)progkey.getAct_value());
            }
            EFCMap wflkey = new EFCMap();
            Object procName = "";
            for (ClSysWflParamDet param : paramList) {
                EFCString sysParamCode = new EFCString("");
                if (param.getSysparamcode().getData() != null) {
                    sysParamCode.setData(param.getSysparamcode().getData().toUpperCase());
                }
                if (proc.getAct_variables().containsKey((Object)param.getWflextparamcode())) {
                    EFCString value = ((BoWflVariable)proc.getAct_variables().get((Object)param.getWflextparamcode())).getAct_value();
                    if (param.getIswflextkey().getData() != null && param.getIswflextkey().getData().booleanValue()) {
                        wflkey.put((Object)sysParamCode, (Object)value);
                    }
                    if (value == null || value.getData() == null || value.getData().isEmpty() || param.getIswflextshow().getData() == null || !param.getIswflextshow().getData().booleanValue()) continue;
                    procName = (String)procName + value + " ";
                    continue;
                }
                if (param.getIswflextkey().getData() == null || !param.getIswflextkey().getData().booleanValue()) continue;
                wflkey.put((Object)sysParamCode, (Object)new EFCString(""));
            }
            EFCWflProgButton gotoPjmButton = null;
            EFCNavigator.ExecProg prog = null;
            if (!wflkey.isEmpty() && (prog = EFCNavigator.getInstance().getProgram(progkey.getAct_value().getData())) != null) {
                Key key = new Key();
                wflkey.entrySet().forEach(entry -> key.addKeyValue(((EFCString)entry.getKey()).getData(), ((EFCString)entry.getValue()).getData()));
                gotoPjmButton = new EFCWflProgButton(Translator.tr((String)("GOTO_" + progkey.getAct_value().getData())), prog, key);
            }
            GridPane gridpane = new GridPane();
            gridpane.setPadding(new Insets(5.0));
            gridpane.setHgap(5.0);
            gridpane.setVgap(5.0);
            Label duration = new Label(Translator.tr((String)"WFL_PROC_DURATION") + ": " + DurationFormatUtils.formatDuration((long)proc.getAct_duration().getLongValue(), (String)"dd:HH:mm", (boolean)true));
            gridpane.add((Node)duration, 0, 0);
            Label start = new Label(Translator.tr((String)"WFL_PROC_START") + ": " + proc.getAct_startTime().toString());
            gridpane.add((Node)start, 0, 1);
            if (gotoPjmButton != null) {
                gridpane.add((Node)gotoPjmButton, 0, 2);
            }
            procName = (String)procName + proc.getAct_defName().getData();
            EFCWflTitledPane titledPane = new EFCWflTitledPane((String)procName, (Node)gridpane);
            titledPane.setMaxWidth(500.0);
            titledPane.setMinWidth(500.0);
            this.add(titledPane);
        }
    }
}

