/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflTaskHeader;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflButton;
import de.effectivecompany.gui.components.fx.wfl.EFCWflTitledPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflToggleButton;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.util.Comparator;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class WflAccordion
extends StackPane {
    private Accordion accordion = new Accordion();
    private final EFCLockPane pin = new EFCLockPane();
    private ScrollPane scroll = new ScrollPane((Node)this.accordion);
    private BorderPane mainborder = new BorderPane();
    private WflPanelType panelType;

    public WflAccordion(String title, WflPanelType panelType) {
        this.panelType = panelType;
        HBox root = new HBox(5.0);
        root.setAlignment(Pos.CENTER_LEFT);
        root.setPadding(new Insets(5.0));
        EFCWflButton hideButton = new EFCWflButton(EFCLookAndFeelManager.ICON_WFL_HIDE);
        root.getChildren().add((Object)hideButton);
        hideButton.setOnAction(event -> WflController.getInstance().showView(WflPanelType.EMPTY, false));
        Label text = new Label();
        text.setContentDisplay(ContentDisplay.CENTER);
        text.setText(title);
        root.getChildren().add((Object)text);
        this.mainborder.setTop((Node)root);
        this.mainborder.setCenter((Node)this.scroll);
        this.getChildren().addAll((Object[])new Node[]{this.mainborder, this.pin});
    }

    public WflPanelType getWflPanelType() {
        return this.panelType;
    }

    public void setTask(BoWflTaskHeader taskHeader) {
    }

    public void addTopBorder(BorderPane topBorder) {
        topBorder.setCenter((Node)this.scroll);
        this.mainborder.setCenter((Node)topBorder);
    }

    public void clear() {
        this.accordion.getPanes().clear();
    }

    public void add(EFCWflTitledPane node) {
        this.accordion.getPanes().add((Object)node);
    }

    public void remove(String taskId) {
        Optional<TitledPane> optional = this.accordion.getPanes().stream().filter(titledPane -> ((EFCWflTitledPane)((Object)titledPane)).getTaskId().equals(taskId)).findFirst();
        if (optional.isPresent() && optional.get() != null) {
            this.accordion.getPanes().remove((Object)optional.get());
        }
    }

    public void setWorking(boolean isWorking) {
        this.pin.setVisible(isWorking);
        WflController.getInstance().getWflButtonBar().getChildren().forEach(e -> {
            if (e instanceof EFCWflToggleButton) {
                ((EFCWflToggleButton)((Object)e)).setEnabled(!isWorking);
            }
        });
    }

    public void sort() {
        this.accordion.getPanes().sort((Comparator)new Comparator<TitledPane>(){

            @Override
            public int compare(TitledPane o1, TitledPane o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
    }
}

