/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflFormValue;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.wfl.EFCWflProgButton;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflGroupTaskPane;
import de.effectivecompany.gui.components.fx.wfl.WflMyQueuedTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.WflMyTaskPane;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.root.EFCNavigator;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;

public class WflActionButtonPane
extends FlowPane {
    public WflActionButtonPane(WflPane parent, BoWflTask task) {
        this.setHgap(10.0);
        if (parent instanceof WflMyTaskPane && task.getAct_endTime().getData() == null) {
            Button complete = new Button(Translator.tr((String)"WFL_TASK_COMPLETE"));
            complete.setId(task.getAct_id().toString());
            complete.setOnAction(e -> {
                Button src = (Button)e.getSource();
                EFCMap vars = new EFCMap();
                for (String v : parent.getModel().keySet()) {
                    if (!v.startsWith(src.getId())) continue;
                    Object value = null;
                    if (parent.getModel().get(v) != null) {
                        value = parent.getModel().get(v).getValue();
                    }
                    EFCString key = new EFCString(v.replace(src.getId(), ""));
                    if (value != null && value instanceof LocalDate) {
                        Instant instant = ((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                        Date res = Date.from(instant);
                        vars.put((Object)key, (Object)new EFCString(Long.toString(res.getTime())));
                        continue;
                    }
                    if (value != null && value instanceof BoWflFormValue) {
                        BoWflFormValue fromValue = (BoWflFormValue)value;
                        vars.put((Object)key, (Object)new EFCString(fromValue.getId().toString()));
                        continue;
                    }
                    if (value == null || value.toString() == null || value.toString().isEmpty()) continue;
                    vars.put((Object)key, (Object)new EFCString(value.toString()));
                }
                WflController.getInstance().completeTask(src.getId(), (EFCMap<EFCString, EFCString>)vars, parent.getErrorMsg());
            });
            this.getChildren().add((Object)complete);
        }
        if (parent instanceof WflGroupTaskPane) {
            Button reclaim = new Button(Translator.tr((String)"WFL_TASK_CLAIMFROMUSER"));
            reclaim.setId(task.getAct_id().toString());
            reclaim.setOnAction(e -> {
                Button src = (Button)e.getSource();
                WflController.getInstance().reClaimTask(src.getId(), parent.getErrorMsg(), false);
            });
            this.getChildren().add((Object)reclaim);
        }
        if ((parent instanceof WflGroupTaskPane || parent instanceof WflMyTaskPane) && task.getPjmprogkey() != null && task.getPjmprogkey().getAct_value() != null && task.getPjmprogkey().getAct_value().getData() != null && !task.getPjmprogkey().getAct_value().getData().equals("DMSTISDOC")) {
            Button unclaim = new Button(Translator.tr((String)"WFL_TASK_UNCLAIM"));
            unclaim.setId(task.getAct_id().toString());
            unclaim.setOnAction(e -> {
                Button src = (Button)e.getSource();
                WflController.getInstance().unclaimTask(src.getId(), parent.getErrorMsg(), false);
            });
            this.getChildren().add((Object)unclaim);
        }
        if (parent instanceof WflMyQueuedTaskListPane) {
            Button start = new Button(Translator.tr((String)"WFL_TASK_CLAIM"));
            start.setId(task.getAct_id().toString());
            start.setOnAction(e -> {
                Button src = (Button)e.getSource();
                WflController.getInstance().claimTask(src.getId(), parent.getErrorMsg(), false);
            });
            this.getChildren().add((Object)start);
        }
        if (task.getPjmprogkey() != null && task.getPjmprogkey().getAct_value() != null && task.getPjmprogkey().getAct_value().getData() != null && !task.getPjmprogkey().getAct_value().getData().equals("DMSTISDOC")) {
            EFCWflProgButton gotoButton = null;
            EFCNavigator.ExecProg prog = null;
            if (task != null && !task.getWflkey().isEmpty() && (prog = EFCNavigator.getInstance().getProgram(task.getPjmprogkey().getAct_value().getData())) != null) {
                Key key = new Key();
                task.getWflkey().entrySet().forEach(entry -> key.addKeyValue(((EFCString)entry.getKey()).getData(), ((EFCString)entry.getValue()).getData()));
                gotoButton = new EFCWflProgButton(Translator.tr((String)("GOTO_" + task.getPjmprogkey().getAct_value().getData())), prog, key);
            }
            if (gotoButton != null) {
                this.getChildren().add(gotoButton);
            }
        }
    }
}

