/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.app.sys.MdSysUsrBas;
import de.effectivecompany.app.syscl.ClSysUsrWflGrp;
import de.effectivecompany.app.syscl.ClSysWflParamDet;
import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.BoWflComment;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.EFCComboBox;
import de.effectivecompany.gui.components.fx.wfl.EFCSelectionListView;
import de.effectivecompany.gui.components.fx.wfl.EFCWflAvailableProcPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflButtonBar;
import de.effectivecompany.gui.components.fx.wfl.EFCWflCreateTaskPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflGroupTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMailInboxListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMyCreatedTaskFinishedListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMyCreatedTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMyProcListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMyQueuedTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.EFCWflMyTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActiveProcessesForActualUserCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActiveProcessesForActualUserService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActiveTasksByGroupCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActiveTasksByGroupService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActualizeProcessesForActualUserCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCActualizeProcessesForActualUserService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCAddCommentService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCClaimTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCCompleteTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCCreateTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCDelegateTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCDeleteAttachmentService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCDeleteCommentService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCEditAttachmentService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetAttachmentContentService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetAttachmentsService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetCommentsService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetFinishedTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetUsersService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCGetWflGroupsService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMailInboxTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMyActiveTasksCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMyActiveTasksService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMyCreatedTasksCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMyCreatedTasksFinshedService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCMyCreatedTasksService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCReClaimTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCSetVariablesForTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCStartProcessService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCTaskForActualUserService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCTasksForActualUserCountService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCUnclaimTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCUndoTaskService;
import de.effectivecompany.gui.components.fx.wfl.service.EFCWflParamsService;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.events.ActivitiChangedEvent;
import de.effectivecompany.gui.events.util.EFCEventBus;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.concurrent.Task;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;

public class WflController
extends StackPane {
    static final int WIDTH_BUTTON_LIST = 36;
    static final int WIDTH_OTHER = 500;
    private EFCClaimTaskService serviceClaimTask;
    private EFCDelegateTaskService serviceDelegateTask;
    private EFCReClaimTaskService serviceReclaimTask;
    private EFCUnclaimTaskService serviceUnclaimTask;
    private EFCCompleteTaskService serviceCompleteTask;
    private EFCStartProcessService serviceStartProcess;
    private EFCActualizeProcessesForActualUserCountService serviceActualizeProcessesForActualUserCount;
    private EFCActualizeProcessesForActualUserService serviceActualizeProcessesForActualUser;
    private EFCActiveProcessesForActualUserCountService serviceActiveProcessesForActualUserCount;
    private EFCActiveProcessesForActualUserCountService adminServiceActiveProcessesForActualUserCount;
    private EFCActiveProcessesForActualUserService serviceActiveProcessesForActualUser;
    private EFCTasksForActualUserCountService serviceTasksForActualUserCount;
    private EFCTasksForActualUserCountService adminServiceTasksForActualUserCount;
    private EFCTaskForActualUserService serviceTasksForActualUser;
    private EFCMyActiveTasksCountService serviceMyActiveTasksCount;
    private static EFCMyActiveTasksService serviceMyActiveTasks;
    private EFCGetAttachmentsService serviceGetAttachments;
    private EFCGetAttachmentContentService serviceGetAttachmentContent;
    private EFCWflButtonBar buttonBar;
    private EFCWflAvailableProcPane availableProcPane;
    private EFCWflCreateTaskPane createTaskPane;
    private static EFCWflMyCreatedTaskListPane myCreatedTasksPane;
    private static EFCWflMyCreatedTaskFinishedListPane myCreatedTasksFinishedPane;
    private EFCWflMailInboxListPane efcWflMailInboxListPane;
    private EFCWflMyProcListPane myProcListPane;
    private static EFCWflMyTaskListPane myTaskListPane;
    private EFCWflGroupTaskListPane groupTaskListPane;
    private EFCWflMyQueuedTaskListPane myQueuedTaskListPane;
    private EFCAddCommentService serviceAddComment;
    private EFCGetCommentsService serviceGetComments;
    private EFCDeleteAttachmentService serviceDeleteAttachment;
    private EFCEditAttachmentService serviceEditAttachment;
    private EFCDeleteCommentService serviceDeleteComment;
    private EFCActiveTasksByGroupCountService serviceActiveTasksByGroupCount;
    private EFCActiveTasksByGroupCountService adminServiceActiveTasksByGroupCount;
    private EFCActiveTasksByGroupService serviceActiveTasksByGroup;
    private EFCWflParamsService serviceWflParams;
    private EFCSetVariablesForTaskService serviceSetTaskVariables;
    private EFCUndoTaskService serviceUndoTask;
    private EFCCreateTaskService serviceCreateTask;
    private EFCGetUsersService serviceGetUsers;
    private EFCGetWflGroupsService serviceGetWflGroups;
    private EFCMyCreatedTasksService serviceMyCreatedTasks;
    private static EFCMyCreatedTasksFinshedService serviceMyCreatedTasksFinshed;
    private EFCMailInboxTaskService efcMailInboxTaskService;
    private EFCMyCreatedTasksCountService serviceMyCreatedTasksCount;
    private EFCMyCreatedTasksCountService adminServiceMyCreatedTasksCount;
    private EFCGetTaskService serviceGetTask;
    private EFCGetFinishedTaskService serviceGetFinishedTask;
    private SimpleStringProperty filter = new SimpleStringProperty();
    private SimpleStringProperty adminFilter = new SimpleStringProperty();
    private SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
    private MdSysUsrBas actualUser = this.svSysApp.getMdSysUsrBas();
    private BorderPane border;
    private WflPanelType actual;
    private JFXPanel fxpanel;
    private static EFCMap<EFCString, EFCList<ClSysWflParamDet>> wflParams;
    private boolean isAdmin;
    private static WflController instance;

    public static WflController getInstance() {
        if (instance == null) {
            instance = new WflController(new JFXPanel());
        }
        return instance;
    }

    public JFXPanel getFxpanel() {
        return this.fxpanel;
    }

    private WflController(JFXPanel panel) {
        this.serviceWflParams = new EFCWflParamsService(this);
        this.fxpanel = panel;
        Task<EFCMap<EFCString, EFCList<ClSysWflParamDet>>> wflParamTask = this.serviceWflParams.start();
        wflParamTask.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                wflParams = (EFCMap)taskEvent.getSource().valueProperty().get();
                this.initServices();
                this.buttonBar = new EFCWflButtonBar(this, this.actualUser.getUsergrp().getData().equals(0));
                this.border = new BorderPane();
                this.border.setRight((Node)this.buttonBar);
                this.getChildren().add((Object)this.border);
                Scene scene = new Scene((Parent)this);
                this.fxpanel.setScene(scene);
                this.showView(WflPanelType.EMPTY, false, null);
            }
        });
        wflParamTask.setOnFailed(taskEvent -> EFCDesktop.reportError("Loading Wfl Params failed", taskEvent.getSource().getException()));
        EFCEventBus.getInstance().register((Object)this);
    }

    private void initServices() {
        this.isAdmin = this.actualUser.getUsergrp().getData().equals(0);
        this.serviceActualizeProcessesForActualUserCount = new EFCActualizeProcessesForActualUserCountService(this);
        this.serviceActualizeProcessesForActualUser = new EFCActualizeProcessesForActualUserService(this);
        this.serviceActiveProcessesForActualUserCount = new EFCActiveProcessesForActualUserCountService(this);
        this.serviceActiveProcessesForActualUser = new EFCActiveProcessesForActualUserService(this);
        this.serviceTasksForActualUserCount = new EFCTasksForActualUserCountService(this);
        this.serviceTasksForActualUser = new EFCTaskForActualUserService(this);
        this.serviceMyActiveTasksCount = new EFCMyActiveTasksCountService(this);
        serviceMyActiveTasks = new EFCMyActiveTasksService(this);
        this.serviceDelegateTask = new EFCDelegateTaskService(this);
        this.serviceClaimTask = new EFCClaimTaskService(this);
        this.serviceUnclaimTask = new EFCUnclaimTaskService(this);
        this.serviceCompleteTask = new EFCCompleteTaskService(this);
        this.serviceStartProcess = new EFCStartProcessService(this);
        this.serviceGetAttachments = new EFCGetAttachmentsService(this);
        this.serviceGetAttachmentContent = new EFCGetAttachmentContentService(this);
        this.serviceGetComments = new EFCGetCommentsService(this);
        this.serviceAddComment = new EFCAddCommentService(this);
        this.serviceDeleteAttachment = new EFCDeleteAttachmentService(this);
        this.serviceEditAttachment = new EFCEditAttachmentService(this);
        this.serviceDeleteComment = new EFCDeleteCommentService(this);
        this.serviceActiveTasksByGroupCount = new EFCActiveTasksByGroupCountService(this);
        this.serviceActiveTasksByGroup = new EFCActiveTasksByGroupService(this);
        this.serviceReclaimTask = new EFCReClaimTaskService(this);
        this.serviceSetTaskVariables = new EFCSetVariablesForTaskService(this);
        this.serviceCreateTask = new EFCCreateTaskService(this);
        this.serviceGetUsers = new EFCGetUsersService(this);
        this.serviceGetWflGroups = new EFCGetWflGroupsService(this);
        this.serviceMyCreatedTasks = new EFCMyCreatedTasksService(this);
        serviceMyCreatedTasksFinshed = new EFCMyCreatedTasksFinshedService(this);
        this.efcMailInboxTaskService = new EFCMailInboxTaskService(this);
        this.serviceMyCreatedTasksCount = new EFCMyCreatedTasksCountService(this);
        this.serviceGetTask = new EFCGetTaskService(this);
        this.serviceGetFinishedTask = new EFCGetFinishedTaskService(this);
        if (this.isAdmin) {
            this.adminServiceActiveProcessesForActualUserCount = new EFCActiveProcessesForActualUserCountService(this);
            this.adminServiceActiveTasksByGroupCount = new EFCActiveTasksByGroupCountService(this);
            this.adminServiceTasksForActualUserCount = new EFCTasksForActualUserCountService(this);
            this.adminServiceMyCreatedTasksCount = new EFCMyCreatedTasksCountService(this);
            this.serviceUndoTask = new EFCUndoTaskService(this);
        }
    }

    public void actualizeButtonBar() {
        this.serviceActualizeProcessesForActualUserCount.start();
        this.serviceActiveProcessesForActualUserCount.start(false);
        this.serviceTasksForActualUserCount.start(false);
        this.serviceMyActiveTasksCount.start();
        this.serviceActiveTasksByGroupCount.start(false);
        this.serviceMyCreatedTasksCount.start(false);
        if (this.actualUser.getUsergrp().getData().equals(0)) {
            this.adminServiceActiveProcessesForActualUserCount.start(true);
            this.adminServiceTasksForActualUserCount.start(true);
            this.adminServiceActiveTasksByGroupCount.start(true);
            this.adminServiceMyCreatedTasksCount.start(true);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onActivitiChangedEvent(ActivitiChangedEvent event) {
        try {
            if (event.getData().getEventType().getData().equals("SYS_WFL_PARAM_UPDATED")) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Task<EFCMap<EFCString, EFCList<ClSysWflParamDet>>> wflParamTask = WflController.this.serviceWflParams.start();
                        wflParamTask.setOnSucceeded(taskEvent -> {
                            if (taskEvent.getSource().valueProperty().get() != null) {
                                wflParams = (EFCMap)taskEvent.getSource().valueProperty().get();
                            }
                        });
                    }
                });
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WflController.this.actualizeButtonBar();
                    }
                });
            }
        }
        catch (ApplicationException ae) {
            EFCDesktop.reportError(ae);
        }
        catch (Throwable th) {
            EFCDesktop.reportError(th);
        }
    }

    public void showView(WflPanelType type, boolean forAdmin) {
        this.showView(type, forAdmin, null);
    }

    public void showView(WflPanelType type, boolean forAdmin, String forTaskEventId) {
        this.actual = type;
        this.availableProcPane = null;
        this.myProcListPane = null;
        myTaskListPane = null;
        this.groupTaskListPane = null;
        this.myQueuedTaskListPane = null;
        this.createTaskPane = null;
        myCreatedTasksPane = null;
        this.actualizeButtonBar();
        this.border.setCenter(null);
        switch (type) {
            case MY_PROCESSES_LIST: {
                this.border.setCenter(this.createMyProcList(forAdmin));
                break;
            }
            case PROCESSES_LIST: {
                this.border.setCenter(this.createAvailableProcList());
                break;
            }
            case QUEUED_TASKS: {
                this.border.setCenter(this.createQueuedTaskList(forAdmin));
                break;
            }
            case TASKS: {
                this.border.setCenter(this.createMyTaskList(forTaskEventId));
                break;
            }
            case GROUP_TASKS: {
                this.border.setCenter(this.createTaskListByGroup(forAdmin));
                break;
            }
            case CREATE_TASK: {
                this.border.setCenter(this.createCreateTask());
                break;
            }
            case MYCREATEDTASKS: 
            case MYTASKS: {
                this.border.setCenter(this.createMyCreatedTasks(forAdmin));
                break;
            }
            case MYCREATEDTASKSFINISHED: {
                this.border.setCenter(this.createMyCreatedTasksFinished(10));
                break;
            }
            case EMPTY: {
                break;
            }
        }
        EFCThreadUtil.doLater(() -> {
            this.fxpanel.setPreferredSize(new Dimension(this.getActualWidth(), 0));
            EFCDesktop.getInstance().revalidate();
        });
    }

    private int getActualWidth() {
        if (this.actual == WflPanelType.EMPTY) {
            return 36;
        }
        return 500;
    }

    private Node createCreateTask() {
        this.createTaskPane = new EFCWflCreateTaskPane(this, this.isAdmin);
        return this.createTaskPane;
    }

    private Node createMyCreatedTasks(boolean forAdmin) {
        if (myCreatedTasksPane == null) {
            myCreatedTasksPane = new EFCWflMyCreatedTaskListPane(this, forAdmin);
        }
        this.serviceMyCreatedTasks.start(this.isAdmin && forAdmin);
        return myCreatedTasksPane;
    }

    private Node createMyCreatedTasksFinished(Integer limit) {
        if (myCreatedTasksFinishedPane == null) {
            myCreatedTasksFinishedPane = new EFCWflMyCreatedTaskFinishedListPane(this, limit);
        }
        serviceMyCreatedTasksFinshed.start(limit);
        return myCreatedTasksFinishedPane;
    }

    public static void actualizeMyCreatedTasksFinished(Integer limit) {
        if (myCreatedTasksFinishedPane != null) {
            serviceMyCreatedTasksFinshed.start(limit);
        }
    }

    private Node createMailInboxTask() {
        if (this.efcWflMailInboxListPane == null) {
            this.efcWflMailInboxListPane = new EFCWflMailInboxListPane(this);
        }
        this.efcMailInboxTaskService.start();
        return this.efcWflMailInboxListPane;
    }

    private Node createAvailableProcList() {
        if (this.availableProcPane == null) {
            this.availableProcPane = new EFCWflAvailableProcPane(this);
        }
        this.serviceActualizeProcessesForActualUser.start(this.isAdmin);
        return this.availableProcPane;
    }

    private Node createMyProcList(boolean forAdmin) {
        if (this.myProcListPane == null) {
            this.myProcListPane = new EFCWflMyProcListPane(this, this.isAdmin && forAdmin);
        }
        this.serviceActiveProcessesForActualUser.start(this.isAdmin && forAdmin);
        return this.myProcListPane;
    }

    private Node createMyTaskList(String forTaskEventId) {
        if (myTaskListPane == null) {
            myTaskListPane = new EFCWflMyTaskListPane();
        }
        serviceMyActiveTasks.start(forTaskEventId);
        return myTaskListPane;
    }

    public static void actualizeMyTaskList() {
        WflController.actualizeMyTaskList(null);
    }

    public static void actualizeMyTaskList(String forTaskEventId) {
        if (myTaskListPane != null) {
            serviceMyActiveTasks.start(forTaskEventId);
        }
    }

    private Node createTaskListByGroup(boolean forAdmin) {
        if (this.groupTaskListPane == null) {
            this.groupTaskListPane = new EFCWflGroupTaskListPane(this, this.isAdmin && forAdmin);
        }
        this.serviceActiveTasksByGroup.start(this.isAdmin && forAdmin);
        return this.groupTaskListPane;
    }

    public void actualizeTaskListByGroup(boolean forAdmin) {
        if (this.myQueuedTaskListPane != null) {
            this.serviceActiveTasksByGroup.start(this.isAdmin && forAdmin);
        }
    }

    private Node createQueuedTaskList(boolean forAdmin) {
        if (this.myQueuedTaskListPane == null) {
            this.myQueuedTaskListPane = new EFCWflMyQueuedTaskListPane(this, this.isAdmin && forAdmin);
        }
        this.serviceTasksForActualUser.start(this.isAdmin && forAdmin);
        return this.myQueuedTaskListPane;
    }

    public void actualizeQueuedTaskList(boolean forAdmin) {
        if (this.myQueuedTaskListPane != null) {
            this.serviceTasksForActualUser.start(this.isAdmin && forAdmin);
        }
    }

    public void actualizeQueuedTaskListCount(boolean forAdmin) {
        if (this.serviceTasksForActualUserCount != null) {
            this.serviceTasksForActualUserCount.start(this.isAdmin && forAdmin);
        }
    }

    public EFCWflMailInboxListPane getEfcWflMailInboxListPane() {
        return this.efcWflMailInboxListPane;
    }

    public void setEfcWflMailInboxListPane(EFCWflMailInboxListPane efcWflMailInboxListPane) {
        this.efcWflMailInboxListPane = efcWflMailInboxListPane;
    }

    public EFCWflMyQueuedTaskListPane getWflMyQueuedTaskListPane() {
        return this.myQueuedTaskListPane;
    }

    public EFCWflAvailableProcPane getWflAvailableProcPane() {
        return this.availableProcPane;
    }

    public static EFCWflMyTaskListPane getWflMyTaskListPane() {
        return myTaskListPane;
    }

    public static EFCWflMyCreatedTaskListPane getWflMyCreatedTaskListPane() {
        return myCreatedTasksPane;
    }

    public static EFCWflMyCreatedTaskFinishedListPane getWflMyCreatedTaskFinishedListPane() {
        return myCreatedTasksFinishedPane;
    }

    public EFCWflGroupTaskListPane getWflTaskByGroupListPane() {
        return this.groupTaskListPane;
    }

    public EFCWflMyProcListPane getWflMyProcListPane() {
        return this.myProcListPane;
    }

    public EFCWflCreateTaskPane getCreateTaskPane() {
        return this.createTaskPane;
    }

    public void unclaimTask(String taskId, Label label, boolean forAdmin) {
        this.serviceUnclaimTask.startService(taskId, label, forAdmin);
    }

    public void startProcess(String id, EFCMap<EFCString, EFCString> variables, Label label) {
        this.serviceStartProcess.startService(id, variables, label);
    }

    public void completeTask(String id, EFCMap<EFCString, EFCString> vars, Label label) {
        this.serviceCompleteTask.startService(id, vars, label);
    }

    public void setTaskVariables(WflPane pane, EFCString id, EFCMap<EFCString, EFCString> vars) {
        this.serviceSetTaskVariables.startService(pane, id, vars);
    }

    public void claimTask(String taskId, Label label, boolean forAdmin) {
        this.serviceClaimTask.startService(taskId, label, forAdmin);
    }

    public void delegateTask(String taskId, Label label, String user, boolean forAdmin) {
        this.serviceDelegateTask.startService(taskId, label, user, forAdmin);
    }

    public void reClaimTask(String taskId, Label label, boolean forAdmin) {
        this.serviceReclaimTask.startService(taskId, label, forAdmin);
    }

    public EFCWflButtonBar getWflButtonBar() {
        return this.buttonBar;
    }

    public void saveAttachment(WflTableBase table, Label label, BoWflAttachment attachment) {
        this.serviceEditAttachment.startService(table, label, attachment);
    }

    public void addComment(WflTableBase table, Label label, String processId, String taskId, String message) {
        this.serviceAddComment.startService(table, label, processId, taskId, message);
    }

    public void deleteComment(WflTableBase table, BoWflComment comment) {
        this.serviceDeleteComment.startService(table, comment);
    }

    public void getComments(WflTableBase dataTable, String processId, String taskId) {
        this.serviceGetComments.startService(dataTable, processId, taskId);
    }

    public void getUsers(EFCSelectionListView<MdSysUsrBas> dataTable, EFCLockPane pin) {
        this.serviceGetUsers.startService(dataTable, pin, false);
    }

    public void getUsers(EFCComboBox dataTable, EFCLockPane pin) {
        this.serviceGetUsers.startService(dataTable, pin, true);
    }

    public Task<BoWflTask> getTaskService(String taskId) {
        Task<BoWflTask> task = this.serviceGetTask.startService(taskId);
        return task;
    }

    public Task<BoWflTask> getFinishedTaskService(String taskId) {
        Task<BoWflTask> task = this.serviceGetFinishedTask.startService(taskId);
        return task;
    }

    public void getWflGroups(EFCSelectionListView<ClSysUsrWflGrp> dataTable, EFCLockPane pin) {
        this.serviceGetWflGroups.startService(dataTable, pin);
    }

    public void getAttachments(WflTableBase dataTable, String processId, String taskId, boolean forProcInstId) {
        this.serviceGetAttachments.startService(dataTable, processId, taskId, forProcInstId);
    }

    public void getAttachmentContent(String name, String attachmentId, boolean isURL) {
        this.serviceGetAttachmentContent.startService(name, attachmentId, isURL);
    }

    public void deleteAttachment(WflTableBase dataTable, BoWflAttachment attachment) {
        this.serviceDeleteAttachment.startService(dataTable, attachment);
    }

    public EFCMap<EFCString, EFCList<ClSysWflParamDet>> getWflParams() {
        return wflParams;
    }

    public void setWflParams(EFCMap<EFCString, EFCList<ClSysWflParamDet>> wflParams) {
        WflController.wflParams = wflParams;
    }

    public void undoTask(String taskId, Label label, boolean forAdmin) {
        this.serviceUndoTask.startService(taskId, label, forAdmin);
    }

    public void createTask(EFCString name, EFCText description, EFCDateTime dueDate, EFCList<EFCString> candidateUsers, EFCList<EFCString> candidateGroups, EFCString assignee, Integer prio, Label label) {
        this.serviceCreateTask.startService(name, description, dueDate, candidateUsers, candidateGroups, assignee, prio, label);
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public EFCTaskForActualUserService getServiceTasksForActualUser() {
        return this.serviceTasksForActualUser;
    }

    public SimpleStringProperty getFilter() {
        return this.filter;
    }

    public SimpleStringProperty getAdminFilter() {
        return this.adminFilter;
    }

    public void executeTask(Task<?> task) {
        EFCThreadUtil.getCachedExecutorService().submit((Runnable)task);
    }

    public WflPanelType getActual() {
        return this.actual;
    }
}

