/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.fx.wfl.WflToolbar;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;

public abstract class WflPane
extends StackPane {
    private EFCMap<String, String> taskProcIdMap = new EFCMap();
    final Map<String, Property<?>> model = new HashMap();
    private BorderPane border = new BorderPane();
    private EFCLockPane pin = new EFCLockPane();
    private boolean forAdmin = false;
    private final WflToolbar toolbar;
    private final Label errorMsg;
    private WflTableBase dataTable = new WflTableBase(this);

    public WflPane(String taskId, boolean forAdmin) {
        this.getChildren().addAll((Object[])new Node[]{this.border, this.pin});
        this.forAdmin = forAdmin;
        this.toolbar = new WflToolbar(taskId, this);
        this.errorMsg = new Label();
        this.errorMsg.setWrapText(true);
        this.errorMsg.setPrefHeight(30.0);
    }

    public void setWorking(boolean working) {
        this.pin.setVisible(working);
    }

    public void setTop(Node node) {
        this.border.setTop(node);
    }

    public void setContent(Node node) {
        ScrollPane scroll = new ScrollPane(node);
        this.border.setCenter((Node)scroll);
    }

    public Map<String, Property<?>> getModel() {
        return this.model;
    }

    public EFCMap<String, String> getTaskProcIdMap() {
        return this.taskProcIdMap;
    }

    public boolean isForAdmin() {
        return this.forAdmin;
    }

    public WflToolbar getToolbar() {
        return this.toolbar;
    }

    public Label getErrorMsg() {
        return this.errorMsg;
    }

    public WflTableBase getWflDataTablebase() {
        return this.dataTable;
    }
}

