/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.BoWflComment;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.components.editor.EFCTextarea;
import de.effectivecompany.gui.components.fx.components.editor.EFCTextfield;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.WflCommentTable;
import de.effectivecompany.gui.components.fx.wfl.WflDataTable;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class WflTableBase
extends VBox {
    private final EFCLockPane dataPin = new EFCLockPane();
    private final EFCLockPane commentPin = new EFCLockPane();
    private WflDataTable dataTable;
    private WflCommentTable commentTable;
    private WflPane parent;
    private final Label dataAttLabel = new Label(Translator.tr((String)"FLD_WFL_DATA_ATTACHMENT_LABEL"));
    private final EFCTextfield attNameTextField = new EFCTextfield("act_name");
    private final EFCTextarea attDescriptionTextArea = new EFCTextarea("act_description");
    private final EFCTextfield attUrlTextField = new EFCTextfield("act_url");
    private final EFCTextfield attUserTextField = new EFCTextfield("act_user");
    private final Label commentLabel = new Label(Translator.tr((String)"FLD_WFL_COMMENT_LABEL"));
    private final EFCTextfield commentMessageTextField = new EFCTextfield("act_message");
    private final EFCTextfield commentUserTextField = new EFCTextfield("act_user");

    public WflTableBase(final WflPane parent) {
        this.parent = parent;
        this.dataTable = new WflDataTable(parent);
        this.dataTable.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            BoWflAttachment item = (BoWflAttachment)this.dataTable.getSelectionModel().getSelectedItem();
            this.attNameTextField.textProperty().unbind();
            this.attDescriptionTextArea.textProperty().unbind();
            this.attUrlTextField.textProperty().unbind();
            this.attUserTextField.textProperty().unbind();
            if (item != null) {
                this.attNameTextField.bindBo((BusinessObject)item);
                this.attDescriptionTextArea.bindBo((BusinessObject)item);
                this.attUrlTextField.bindBo((BusinessObject)item);
                this.attUserTextField.bindBo((BusinessObject)item);
            }
        });
        this.commentTable = new WflCommentTable(parent);
        this.commentTable.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                BoWflComment item = (BoWflComment)WflTableBase.this.commentTable.getSelectionModel().getSelectedItem();
                parent.getWflDataTablebase().getCommentUserTextField().textProperty().unbind();
                parent.getWflDataTablebase().getCommentMessageTextField().textProperty().unbind();
                if (item != null) {
                    parent.getWflDataTablebase().getCommentMessageTextField().bindBo((BusinessObject)item);
                    parent.getWflDataTablebase().getCommentUserTextField().bindBo((BusinessObject)item);
                }
            }
        });
        this.attNameTextField.setPromptText(Translator.tr((String)"FLD_ACT_NAME"));
        this.attNameTextField.setPrefWidth(this.dataTable.getDataName().getPrefWidth());
        this.dataTable.getDataName().widthProperty().addListener((observable, oldValue, newValue) -> this.attNameTextField.setPrefWidth(newValue.doubleValue()));
        this.attDescriptionTextArea.setMaxHeight(50.0);
        this.attDescriptionTextArea.setPrefWidth(this.dataTable.getAttDescription().getPrefWidth());
        this.attDescriptionTextArea.setPromptText(Translator.tr((String)"FLD_ACT_DESCRIPTION"));
        this.dataTable.getAttDescription().widthProperty().addListener((observable, oldValue, newValue) -> this.attDescriptionTextArea.setPrefWidth(newValue.doubleValue()));
        this.attUrlTextField.setPromptText(Translator.tr((String)"FLD_ACT_URL"));
        this.attUrlTextField.setPrefWidth(this.dataTable.getDataURL().getPrefWidth());
        this.dataTable.getDataURL().widthProperty().addListener((observable, oldValue, newValue) -> this.attUrlTextField.setPrefWidth(newValue.doubleValue()));
        this.commentMessageTextField.setPromptText(Translator.tr((String)"FLD_ACT_MESSAGE"));
        this.commentMessageTextField.setPrefWidth(this.commentTable.getCommentMessage().getPrefWidth());
        this.commentTable.getCommentMessage().widthProperty().addListener((observable, oldValue, newValue) -> this.commentMessageTextField.setPrefWidth(newValue.doubleValue()));
        this.commentUserTextField.setPromptText(Translator.tr((String)"FLD_ACT_USER"));
        this.commentUserTextField.setPrefWidth(this.commentTable.getCommentUser().getPrefWidth());
        this.commentTable.getCommentUser().widthProperty().addListener((observable, oldValue, newValue) -> this.commentUserTextField.setPrefWidth(newValue.doubleValue()));
        StackPane dataPane = new StackPane();
        dataPane.getChildren().addAll((Object[])new Node[]{this.dataTable, this.dataPin});
        HBox datatableHBox = new HBox(new Node[]{this.attNameTextField, this.attUrlTextField, this.attDescriptionTextArea, this.attUserTextField});
        ScrollPane dataTableScrollPane = new ScrollPane((Node)datatableHBox);
        HBox commenttableHBox = new HBox(new Node[]{this.commentMessageTextField, this.commentUserTextField});
        ScrollPane commentTableScrollPane = new ScrollPane((Node)commenttableHBox);
        StackPane commentPane = new StackPane();
        commentPane.getChildren().addAll((Object[])new Node[]{this.commentTable, this.commentPin});
        this.setSpacing(5.0);
        this.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{this.dataAttLabel, dataPane, dataTableScrollPane, this.commentLabel, commentPane, commentTableScrollPane});
    }

    public WflDataTable getDataTable() {
        return this.dataTable;
    }

    public void setDataTable(WflDataTable dataTable) {
        this.dataTable = dataTable;
    }

    public WflCommentTable getCommentTable() {
        return this.commentTable;
    }

    public void setCommentTable(WflCommentTable commentTable) {
        this.commentTable = commentTable;
    }

    public EFCLockPane getcommentPin() {
        return this.commentPin;
    }

    public EFCLockPane getDataPin() {
        return this.dataPin;
    }

    public EFCTextfield getAttNameTextField() {
        return this.attNameTextField;
    }

    public EFCTextarea getAttDescriptionTextArea() {
        return this.attDescriptionTextArea;
    }

    public EFCTextfield getAttUrlTextField() {
        return this.attUrlTextField;
    }

    public EFCTextfield getAttUserTextField() {
        return this.attUserTextField;
    }

    public EFCTextfield getCommentMessageTextField() {
        return this.commentMessageTextField;
    }

    public EFCTextfield getCommentUserTextField() {
        return this.commentUserTextField;
    }
}

