/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflExecution;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActiveProcessesForActualUserService {
    private static Logger logger = LoggerFactory.getLogger(EFCActiveProcessesForActualUserService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCActiveProcessesForActualUserService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean forAdmin) {
        if (forAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(true);
        }
        this.controller.getWflMyProcListPane().setWorking(true);
        Task<EFCList<BoWflExecution>> task = this.createTask(forAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && this.controller.getWflMyProcListPane() != null) {
                this.controller.getWflMyProcListPane().setMyProcs((List)taskEvent.getSource().valueProperty().get());
            }
            if (forAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(false);
            }
            if (this.controller.getWflMyProcListPane() != null) {
                this.controller.getWflMyProcListPane().setWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (forAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(false);
            }
            if (this.controller.getWflMyProcListPane() != null) {
                this.controller.getWflMyProcListPane().setWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflExecution>> createTask(final boolean forAdmin) {
        return new Task<EFCList<BoWflExecution>>(){

            protected EFCList<BoWflExecution> call() throws Exception {
                if (forAdmin) {
                    return EFCActiveProcessesForActualUserService.this.processes.getActiveProcessesForAdmin();
                }
                return EFCActiveProcessesForActualUserService.this.processes.getActiveProcessesForActualUser();
            }
        };
    }
}

