/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActiveTasksByGroupCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCActiveTasksByGroupCountService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCActiveTasksByGroupCountService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean isAdmin) {
        if (isAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeActiveTasksByGroupCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeActiveTasksByGroupCountWorking(true);
        }
        Task<Integer> task = this.createTask(isAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                if (isAdmin) {
                    this.controller.getWflButtonBar().adminActualizeActiveTasksByGroupCount((Integer)taskEvent.getSource().valueProperty().get());
                } else {
                    this.controller.getWflButtonBar().actualizeActiveTasksByGroupCount((Integer)taskEvent.getSource().valueProperty().get());
                }
            }
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveTasksByGroupCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveTasksByGroupCountWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveTasksByGroupCountWorking(false);
                this.controller.getWflButtonBar().adminActualizeActiveTasksByGroupCount(0);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveTasksByGroupCountWorking(false);
                this.controller.getWflButtonBar().actualizeActiveTasksByGroupCount(0);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask(final boolean isAdmin) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                if (isAdmin) {
                    return EFCActiveTasksByGroupCountService.this.tasks.getActiveTasksForGroupForAdminCount().getIntValue();
                }
                return EFCActiveTasksByGroupCountService.this.tasks.getActiveTasksForGroupCount().getIntValue();
            }
        };
    }
}

