/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActualizeProcessesForActualUserCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCActualizeProcessesForActualUserCountService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCActualizeProcessesForActualUserCountService(WflController controller) {
        this.controller = controller;
    }

    public void start() {
        Task<Integer> task = this.createTask();
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                int procCount = (Integer)taskEvent.getSource().valueProperty().get();
                this.controller.getWflButtonBar().actualizeProcessesForActualUserCount(procCount);
            }
        });
        task.setOnFailed(taskEvent -> {
            this.controller.setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            this.controller.getWflButtonBar().actualizeProcessesForActualUserCount(0);
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask() {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                Integer procCount = EFCActualizeProcessesForActualUserCountService.this.processes.getProcessesForActualUserCount().getIntValue();
                return procCount;
            }
        };
    }
}

