/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflProcDefEntry;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActualizeProcessesForActualUserService {
    private static Logger logger = LoggerFactory.getLogger(EFCActualizeProcessesForActualUserService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCActualizeProcessesForActualUserService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean forAdmin) {
        this.controller.getWflAvailableProcPane().setWorking(true);
        Task<EFCList<BoWflProcDefEntry>> task = this.createTask();
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                this.controller.getWflAvailableProcPane().setAvailableProcs((List)taskEvent.getSource().valueProperty().get());
            }
            this.controller.getWflAvailableProcPane().setWorking(false);
        });
        task.setOnFailed(taskEvent -> {
            this.controller.getWflAvailableProcPane().setWorking(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflProcDefEntry>> createTask() {
        return new Task<EFCList<BoWflProcDefEntry>>(){

            protected EFCList<BoWflProcDefEntry> call() throws Exception {
                return EFCActualizeProcessesForActualUserService.this.processes.getProcessesForActualUser();
            }
        };
    }
}

