/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCCompleteTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCCompleteTaskService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCCompleteTaskService() {
    }

    public EFCCompleteTaskService(WflController controller) {
        this.controller = controller;
    }

    public void startService(String taskId, EFCMap<EFCString, EFCString> variables, Label label) {
        if (this.controller != null) {
            EFCCompleteTaskService eFCCompleteTaskService = this;
            if (eFCCompleteTaskService.controller.getWflMyTaskListPane() != null) {
                EFCCompleteTaskService eFCCompleteTaskService2 = this;
                eFCCompleteTaskService2.controller.getWflMyTaskListPane().setWorking(true);
            }
        }
        if (this.controller != null) {
            EFCCompleteTaskService eFCCompleteTaskService = this;
            if (eFCCompleteTaskService.controller.getWflMyCreatedTaskListPane() != null) {
                EFCCompleteTaskService eFCCompleteTaskService3 = this;
                eFCCompleteTaskService3.controller.getWflMyCreatedTaskListPane().setWorking(true);
            }
        }
        Task<BoWflTask> task = this.createTask(taskId, variables);
        task.setOnSucceeded(this.getonSucceededHandler(label, taskId));
        task.setOnFailed(this.getonFailedHandler(label));
        this.controller.executeTask(task);
    }

    public void startService(String taskId, EFCMap<EFCString, EFCString> variables) {
        Task<BoWflTask> task = this.createTask(taskId, variables);
        task.setOnSucceeded(this.getonSucceededHandler(null, taskId));
        task.setOnFailed(this.getonFailedHandler(null));
        this.controller.executeTask(task);
    }

    private Task<BoWflTask> createTask(final String taskId, final EFCMap<EFCString, EFCString> variables) {
        return new Task<BoWflTask>(){

            protected BoWflTask call() throws Exception {
                return EFCCompleteTaskService.this.tasks.completeTask(new EFCString(taskId), variables);
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonFailedHandler(Label label) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (EFCCompleteTaskService.this.controller != null) {
                    if (EFCCompleteTaskService.this.controller != null) {
                        EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                        if (eFCCompleteTaskService.controller.getWflMyTaskListPane() != null) {
                            EFCCompleteTaskService eFCCompleteTaskService2 = EFCCompleteTaskService.this;
                            eFCCompleteTaskService2.controller.getWflMyTaskListPane().setWorking(false);
                        }
                    }
                    if (EFCCompleteTaskService.this.controller != null) {
                        EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                        if (eFCCompleteTaskService.controller.getWflMyCreatedTaskListPane() != null) {
                            EFCCompleteTaskService eFCCompleteTaskService3 = EFCCompleteTaskService.this;
                            eFCCompleteTaskService3.controller.getWflMyCreatedTaskListPane().setWorking(false);
                        }
                    }
                }
                if (!(event.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                    EFCDesktop.showErrorDlg(event.getSource().exceptionProperty().get().toString());
                }
                logger.error("", event.getSource().exceptionProperty().get());
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonSucceededHandler(final Label label, final String taskId) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (label != null) {
                    if (event.getSource().valueProperty().get() != null && ((BoWflTask)event.getSource().valueProperty().get()).getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                        StringBuilder message = new StringBuilder("");
                        ((BoWflTask)event.getSource().valueProperty().get()).getCompleteMsgList().getMsgList().forEach(msg -> message.append(msg.getMsg().getMsg()));
                        label.setText(message.toString());
                    } else {
                        label.setText("Aufgabe beendet.");
                        if (EFCCompleteTaskService.this.controller != null) {
                            EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                            if (eFCCompleteTaskService.controller.getWflMyTaskListPane() != null) {
                                EFCCompleteTaskService eFCCompleteTaskService2 = EFCCompleteTaskService.this;
                                eFCCompleteTaskService2.controller.getWflMyTaskListPane().remove(taskId);
                            }
                        }
                        if (EFCCompleteTaskService.this.controller != null) {
                            EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                            if (eFCCompleteTaskService.controller.getWflMyCreatedTaskListPane() != null) {
                                EFCCompleteTaskService eFCCompleteTaskService3 = EFCCompleteTaskService.this;
                                eFCCompleteTaskService3.controller.getWflMyCreatedTaskListPane().remove(taskId);
                            }
                        }
                    }
                }
                if (EFCCompleteTaskService.this.controller != null) {
                    EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                    if (eFCCompleteTaskService.controller.getWflMyTaskListPane() != null) {
                        EFCCompleteTaskService eFCCompleteTaskService4 = EFCCompleteTaskService.this;
                        eFCCompleteTaskService4.controller.getWflMyTaskListPane().setWorking(false);
                    }
                }
                if (EFCCompleteTaskService.this.controller != null) {
                    EFCCompleteTaskService eFCCompleteTaskService = EFCCompleteTaskService.this;
                    if (eFCCompleteTaskService.controller.getWflMyCreatedTaskListPane() != null) {
                        EFCCompleteTaskService eFCCompleteTaskService5 = EFCCompleteTaskService.this;
                        eFCCompleteTaskService5.controller.getWflMyCreatedTaskListPane().setWorking(false);
                    }
                }
            }
        };
    }
}

