/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCCreateTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCCreateTaskService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCCreateTaskService(WflController controller) {
        this.controller = controller;
    }

    public void startService(EFCString name, EFCText description, EFCDateTime dueDate, EFCList<EFCString> candidateUsers, EFCList<EFCString> candidateGroups, EFCString assignee, Integer prio, Label label) {
        if (this.controller.getCreateTaskPane() != null) {
            this.controller.getCreateTaskPane().setWorking(true);
        }
        Task<BoWflTask> task = this.createTask(name, description, dueDate, candidateUsers, candidateGroups, assignee, prio);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && ((BoWflTask)taskEvent.getSource().valueProperty().get()).getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                StringBuilder message = new StringBuilder("");
                ((BoWflTask)taskEvent.getSource().valueProperty().get()).getCompleteMsgList().getMsgList().forEach(msg -> message.append(msg.getMsg().getMsg()));
                label.setText(message.toString());
            } else {
                this.controller.showView(WflPanelType.EMPTY, this.controller.isAdmin());
            }
            if (this.controller.getCreateTaskPane() != null) {
                this.controller.getCreateTaskPane().setWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (this.controller.getCreateTaskPane() != null) {
                this.controller.getCreateTaskPane().setWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<BoWflTask> createTask(final EFCString name, final EFCText description, final EFCDateTime dueDate, final EFCList<EFCString> candidateUsers, final EFCList<EFCString> candidateGroups, final EFCString assignee, final Integer prio) {
        return new Task<BoWflTask>(){

            protected BoWflTask call() throws Exception {
                return EFCCreateTaskService.this.tasks.createTask(name, description, dueDate, candidateUsers, candidateGroups, assignee, new EFCInteger(prio));
            }
        };
    }
}

