/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCEditAttachmentService {
    private static Logger logger = LoggerFactory.getLogger(EFCEditAttachmentService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCEditAttachmentService(WflController controller) {
        this.controller = controller;
    }

    public void startService(WflTableBase table, Label label, BoWflAttachment clientAttachment) {
        table.getDataPin().setVisible(true);
        Task<BoWflAttachment> task = this.createTask(clientAttachment);
        task.setOnSucceeded(taskEvent -> {
            if (table != null && taskEvent.getSource().valueProperty().get() != null) {
                BoWflAttachment attachment = (BoWflAttachment)taskEvent.getSource().valueProperty().get();
                int index = table.getDataTable().getItems().indexOf((Object)clientAttachment);
                table.getDataTable().getItems().set(index, (Object)attachment);
                table.disableProperty().setValue(Boolean.valueOf(false));
            }
            table.getDataPin().setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            table.getDataPin().setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<BoWflAttachment> createTask(final BoWflAttachment clientAttachment) {
        return new Task<BoWflAttachment>(){

            protected BoWflAttachment call() throws Exception {
                return EFCEditAttachmentService.this.processes.saveAttachment(clientAttachment);
            }
        };
    }
}

