/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.DcWflAttachment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import java.awt.Desktop;
import java.io.File;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGetAttachmentContentService {
    private static Logger logger = LoggerFactory.getLogger(EFCGetAttachmentContentService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController wflController;
    private EFCController efcController;

    public EFCGetAttachmentContentService(WflController controller) {
        this.wflController = controller;
    }

    public EFCGetAttachmentContentService(EFCController controller) {
        this.efcController = controller;
    }

    public void startService(String name, String attachmentId, boolean isURL) {
        if (this.wflController != null) {
            EFCGetAttachmentContentService eFCGetAttachmentContentService = this;
            if (eFCGetAttachmentContentService.wflController.getWflMyTaskListPane() != null) {
                EFCGetAttachmentContentService eFCGetAttachmentContentService2 = this;
                eFCGetAttachmentContentService2.wflController.getWflMyTaskListPane().setWorking(true);
            }
        }
        if (this.efcController != null) {
            this.efcController.lockControl();
        }
        Task<DcWflAttachment> task = this.createTask(attachmentId, isURL);
        task.setOnSucceeded(this.getonSucceededHandler(name));
        task.setOnFailed(taskEvent -> {
            if (this.wflController != null) {
                EFCGetAttachmentContentService eFCGetAttachmentContentService = this;
                if (eFCGetAttachmentContentService.wflController.getWflMyTaskListPane() != null) {
                    EFCGetAttachmentContentService eFCGetAttachmentContentService2 = this;
                    eFCGetAttachmentContentService2.wflController.getWflMyTaskListPane().setWorking(false);
                }
            }
            if (this.efcController != null) {
                this.efcController.unlockControl();
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        WflController.getInstance().executeTask(task);
    }

    private Task<DcWflAttachment> createTask(final String id, final boolean isURL) {
        return new Task<DcWflAttachment>(){

            protected DcWflAttachment call() throws Exception {
                if (isURL) {
                    DcWflAttachment attachement = new DcWflAttachment();
                    attachement.setUrl(id);
                    return attachement;
                }
                return EFCGetAttachmentContentService.this.processes.getAttachmentContent(id);
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonSucceededHandler(final String name) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (event.getSource().valueProperty().get() != null && event.getSource().valueProperty().get() instanceof DcWflAttachment) {
                    DcWflAttachment attachment = (DcWflAttachment)event.getSource().valueProperty().get();
                    if (attachment.getUrl().getData() != null) {
                        Desktop dt = Desktop.getDesktop();
                        File file = new File(attachment.getUrl().getData());
                        try {
                            dt.open(file);
                        }
                        catch (Throwable e) {
                            logger.error("File not found", e);
                            EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_FILE_NOT_FOUND"));
                        }
                    } else {
                        EFCViewerFactory.createViewer(name, attachment.getData());
                    }
                } else {
                    EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_OPENVIEWER_NOT_POSSIBLE"));
                }
                if (EFCGetAttachmentContentService.this.wflController != null) {
                    EFCGetAttachmentContentService eFCGetAttachmentContentService = EFCGetAttachmentContentService.this;
                    if (eFCGetAttachmentContentService.wflController.getWflMyTaskListPane() != null) {
                        EFCGetAttachmentContentService eFCGetAttachmentContentService2 = EFCGetAttachmentContentService.this;
                        eFCGetAttachmentContentService2.wflController.getWflMyTaskListPane().setWorking(false);
                    }
                }
                if (EFCGetAttachmentContentService.this.efcController != null) {
                    EFCGetAttachmentContentService.this.efcController.unlockControl();
                }
            }
        };
    }
}

