/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflComment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGetCommentsService {
    private static Logger logger = LoggerFactory.getLogger(EFCGetCommentsService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCGetCommentsService(WflController controller) {
        this.controller = controller;
    }

    public void startService(WflTableBase commentTable, String processId, String taskId) {
        commentTable.getcommentPin().setVisible(true);
        Task<EFCList<BoWflComment>> task = processId != null && !processId.isEmpty() ? this.createTaskForProcessId(processId) : this.createTaskForTaskId(taskId);
        task.setOnSucceeded(event -> {
            if (commentTable != null) {
                commentTable.getCommentTable().getItems().clear();
                if (event.getSource().valueProperty().get() != null) {
                    commentTable.getCommentTable().setItems(FXCollections.observableArrayList((Collection)((EFCList)event.getSource().valueProperty().get())));
                }
            }
            commentTable.getcommentPin().setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            commentTable.getcommentPin().setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflComment>> createTaskForProcessId(final String processId) {
        return new Task<EFCList<BoWflComment>>(){

            protected EFCList<BoWflComment> call() throws Exception {
                return EFCGetCommentsService.this.processes.getCommentsForProc(processId);
            }
        };
    }

    private Task<EFCList<BoWflComment>> createTaskForTaskId(final String taskId) {
        return new Task<EFCList<BoWflComment>>(){

            protected EFCList<BoWflComment> call() throws Exception {
                return EFCGetCommentsService.this.processes.getCommentsForTask(taskId);
            }
        };
    }
}

