/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMyActiveTasksCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCMyActiveTasksCountService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCMyActiveTasksCountService(WflController controller) {
        this.controller = controller;
    }

    public void start() {
        this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(true);
        Task<Integer> task = this.createTask();
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                this.controller.getWflButtonBar().actualizeMyActiveTasksCount((Integer)taskEvent.getSource().valueProperty().get());
            }
            this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(false);
        });
        task.setOnFailed(taskEvent -> {
            this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            this.controller.getWflButtonBar().actualizeMyActiveTasksCount(0);
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask() {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                return EFCMyActiveTasksCountService.this.tasks.getMyActiveTasksCount().getIntValue();
            }
        };
    }
}

