/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMyCreatedTasksCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCMyCreatedTasksCountService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCMyCreatedTasksCountService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean isAdmin) {
        if (isAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeMyCreatedTasksCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(true);
        }
        Task<Integer> task = this.createTask(isAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                if (isAdmin) {
                    this.controller.getWflButtonBar().adminActualizeMyCreatedTasksCount((Integer)taskEvent.getSource().valueProperty().get());
                    this.controller.getWflButtonBar().setAdminActualizeMyCreatedTasksCountWorking(false);
                } else {
                    this.controller.getWflButtonBar().actualizeMyCreatedTasksCount((Integer)taskEvent.getSource().valueProperty().get());
                    this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(false);
                }
            }
        });
        task.setOnFailed(taskEvent -> {
            if (isAdmin) {
                this.controller.getWflButtonBar().adminActualizeMyCreatedTasksCount(0);
                this.controller.getWflButtonBar().setAdminActualizeMyCreatedTasksCountWorking(false);
            } else {
                this.controller.getWflButtonBar().actualizeMyCreatedTasksCount(0);
                this.controller.getWflButtonBar().setActualizeMyActiveTasksCountWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask(final boolean isAdmin) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                if (isAdmin) {
                    return EFCMyCreatedTasksCountService.this.tasks.getMyCreatedTasksCountForAdmin().getIntValue();
                }
                return EFCMyCreatedTasksCountService.this.tasks.getMyCreatedTasksCount().getIntValue();
            }
        };
    }
}

