/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model;

import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.base.i18n.Translator;

public class CBEntry {
    public String key;
    public Integer value;
    public Class<? extends OptionObject> optionClass;

    public CBEntry(String k, Integer v, Class<? extends OptionObject> optionClass) {
        this.key = k;
        this.value = v;
        this.optionClass = optionClass;
    }

    public String toString() {
        if (this.key != "-") {
            return Translator.tr((String)CBEntry.genKey(this.key, this.optionClass.getSimpleName().toUpperCase()));
        }
        return "-";
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.key.equals(obj);
        }
        if (obj instanceof Integer) {
            return this.value.equals(obj);
        }
        if (obj instanceof CBEntry) {
            CBEntry otherObj = (CBEntry)obj;
            return this.value.equals(otherObj.value) && this.key.equals(otherObj.key);
        }
        return super.equals(obj);
    }

    public static String genKey(String optValue, String optionClass) {
        String key = "OPT_" + optionClass + "_" + optValue.toUpperCase();
        return key;
    }
}

