/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model;

import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.gui.components.model.CBEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

public class MapComboBoxModel
implements ComboBoxModel {
    private List<CBEntry> data;
    private CBEntry selected;
    private Class<? extends OptionObject> optionClass;
    private List<ListDataListener> listener = new ArrayList<ListDataListener>(2);
    private boolean withNullField;

    public List<CBEntry> getData() {
        return this.data;
    }

    public MapComboBoxModel(Map<String, Integer> data, Class<? extends OptionObject> optionClass) {
        this.data = new ArrayList<CBEntry>(data.size());
        TreeMap<Object, Integer> sortedData = new TreeMap<Object, Integer>(new ValueSorter(data));
        sortedData.putAll(data);
        Set values = sortedData.entrySet();
        for (Map.Entry e : values) {
            this.data.add(new CBEntry((String)e.getKey(), (Integer)e.getValue(), optionClass));
        }
        this.optionClass = optionClass;
    }

    public static String genKeyShort(String optValue, String optionClass) {
        String key = "OPT_" + optionClass + "_" + optValue.toUpperCase() + "_S";
        return key;
    }

    @Override
    public Object getElementAt(int index) {
        int size = this.data.size();
        if (this.isWithNullField()) {
            ++size;
        }
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index has to be between 0 and " + this.data.size());
        }
        if (this.isWithNullField()) {
            if (index == 0) {
                return null;
            }
            return this.data.get(index - 1);
        }
        return this.data.get(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    public String getSelectedItemKey() {
        CBEntry selVal = (CBEntry)this.getSelectedItem();
        if (selVal == null) {
            return null;
        }
        return selVal.toString();
    }

    public Integer getSelectedItemValue() {
        CBEntry selVal = (CBEntry)this.getSelectedItem();
        if (selVal == null) {
            return null;
        }
        return selVal.value;
    }

    public int getValueIndex(int value) {
        for (CBEntry e : this.data) {
            if (e.value != value) continue;
            if (this.isWithNullField()) {
                return this.data.indexOf(e) + 1;
            }
            return this.data.indexOf(e);
        }
        return -1;
    }

    public int getKeyIndex(String key) {
        for (CBEntry e : this.data) {
            if (!e.key.equals(key)) continue;
            return this.data.indexOf(e);
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this.isWithNullField() ? this.data.size() + 1 : this.data.size();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listener.remove(l);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof Integer || item instanceof String) {
            for (CBEntry entry : this.data) {
                if (!entry.equals(item)) continue;
                this.selected = entry;
                break;
            }
        } else {
            this.selected = item instanceof CBEntry ? (CBEntry)item : null;
        }
    }

    public void setWithNullField(boolean withNullField) {
        this.withNullField = withNullField;
    }

    public boolean isWithNullField() {
        return this.withNullField;
    }

    private static class ValueSorter
    implements Comparator<Object> {
        private Map<String, Integer> _data = null;

        public ValueSorter(Map<String, Integer> data) {
            this._data = data;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer e1 = this._data.get(o1);
            Integer e2 = this._data.get(o2);
            return e1.compareTo(e2);
        }
    }
}

