/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnControlPopup;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class EFCColumnControlButton
extends ColumnControlButton {
    private static final long serialVersionUID = -6995390064577429406L;
    private DefaultColumnControlPopup popup;

    public EFCColumnControlButton(JXTable table) {
        super(table);
    }

    protected ColumnControlPopup createColumnControlPopup() {
        this.popup = new DefaultColumnControlPopup();
        return this.popup;
    }

    protected TableColumnModelListener createColumnModelListener() {
        return new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, true)) {
                    EFCColumnControlButton.this.populatePopup();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, false)) {
                    EFCColumnControlButton.this.populatePopup();
                }
            }

            private boolean isVisibilityChange(TableColumnModelEvent e, boolean added) {
                if (!(e.getSource() instanceof DefaultTableColumnModelExt)) {
                    return false;
                }
                DefaultTableColumnModelExt model = (DefaultTableColumnModelExt)e.getSource();
                if (added) {
                    return model.isAddedFromInvisibleEvent(e.getToIndex());
                }
                return model.isRemovedToInvisibleEvent(e.getFromIndex());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    static class CustomList
    extends JComponent {
        private static final long serialVersionUID = 7536981280038742047L;
        private JList list;
        private JScrollPane scrollPane;
        private Dimension size;

        public CustomList(DefaultListModel model) {
            this.list = new JList(model);
            this.list.setBackground(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
            MouseAdapter mouseListListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (list.getSelectedValue() instanceof JCheckBoxMenuItem) {
                        JCheckBoxMenuItem boxMenuItem = (JCheckBoxMenuItem)list.getSelectedValue();
                        if (!e.isConsumed()) {
                            boxMenuItem.setSelected(!boxMenuItem.isSelected());
                            list.repaint();
                            e.consume();
                        }
                    }
                }
            };
            this.list.addMouseListener(mouseListListener);
            this.list.setCellRenderer(new EFCPopupListCellRenderer());
            this.scrollPane = new JScrollPane(this.list);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.setLayout(new BorderLayout());
            this.add((Component)this.scrollPane, "Center");
        }

        public JList getList() {
            return this.list;
        }

        public void clearList() {
            ((DefaultListModel)this.list.getModel()).clear();
        }

        class EFCPopupListCellRenderer
        extends JCheckBoxMenuItem
        implements ListCellRenderer {
            private static final long serialVersionUID = 9004466267002304175L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean a, boolean b) {
                if (value instanceof String) {
                    this.setText((String)value);
                } else if (value instanceof JCheckBoxMenuItem) {
                    this.setText(((JCheckBoxMenuItem)value).getText());
                    this.setSelected(((JCheckBoxMenuItem)value).isSelected());
                }
                return this;
            }
        }
    }

    public class DefaultColumnControlPopup
    implements ColumnControlPopup {
        private DefaultListModel model = new DefaultListModel();
        private JPopupMenu popupMenu;
        private CustomList custom = new CustomList(this.model);

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }

        public void toggleVisibility(JComponent owner) {
            JPopupMenu popupMenu = this.getPopupMenu();
            if (popupMenu.isVisible()) {
                popupMenu.setVisible(false);
            } else if (popupMenu.getComponentCount() > 0) {
                Dimension buttonSize = owner.getSize();
                int xPos = owner.getComponentOrientation().isLeftToRight() ? buttonSize.width - popupMenu.getPreferredSize().width : 0;
                popupMenu.show(owner, xPos, buttonSize.height);
            }
        }

        public void applyComponentOrientation(ComponentOrientation o) {
            this.getPopupMenu().applyComponentOrientation(o);
        }

        public void removeAll() {
            this.getPopupMenu().removeAll();
        }

        public void addVisibilityActionItems(List<? extends AbstractActionExt> actions) {
            this.custom.clearList();
            this.addItems(new ArrayList<AbstractActionExt>(actions));
            this.getPopupMenu().add(this.custom);
        }

        public void addAdditionalActionItems(List<? extends Action> actions) {
        }

        protected void addItems(List<? extends Action> actions) {
            ActionContainerFactory factory = new ActionContainerFactory(null);
            for (Action action : actions) {
                this.addItem(factory.createMenuItem(action));
            }
        }

        protected void addSeparator() {
            this.getPopupMenu().addSeparator();
        }

        protected void addItem(JMenuItem item) {
            ((DefaultListModel)this.custom.getList().getModel()).addElement(item);
        }

        protected JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu;
        }
    }
}

