/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.SelectResult;
import de.effectivecompany.base.gui.interfaces.SelectService;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.gui.components.model.table.EmptySelectResult;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectServiceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 11345162384555L;
    private static Logger logger = LoggerFactory.getLogger(SelectServiceTableModel.class);
    private String[] columns;
    private List<SelectResult> data;
    private SelectService selectSvc;

    public SelectServiceTableModel() {
    }

    public SelectServiceTableModel(SelectService svc) {
        this();
        this.setSelectService(svc);
    }

    @Override
    public String getColumnName(int column) {
        if (this.columns == null) {
            return super.getColumnName(column);
        }
        Object key = this.columns[column];
        if (((String)key).contains(".")) {
            key = ((String)key).substring(((String)key).lastIndexOf(".") + 1);
        }
        key = "FLD_" + (String)key;
        return Translator.tr((String)((String)key).toUpperCase());
    }

    public String getColumnIdentifier(int column) {
        if (column > this.columns.length) {
            return null;
        }
        return this.columns[column];
    }

    public String[] getColumns() {
        return this.columns == null ? new String[]{} : this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = Arrays.copyOf(columns, columns.length);
    }

    public void setColumns(List<String> columns) {
        this.columns = columns.toArray(new String[0]);
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        if (this.data == null || this.data.size() <= rowIndex) {
            return null;
        }
        if (this.columns == null || this.columns.length <= columnIndex) {
            return null;
        }
        return this.getObjectValueAt(rowIndex, this.columns[columnIndex]);
    }

    public Key getKeyAt(int row) {
        return row >= 0 && this.data.size() > row ? this.data.get(row).getKey() : null;
    }

    public SelectResult getObjectAt(int row) {
        return row >= 0 ? this.data.get(row) : null;
    }

    public Object getObjectValueAt(int row, String attributeName) {
        SelectResult target = this.data.get(row);
        if (target instanceof EmptySelectResult) {
            return new EFCString();
        }
        Object obj = ObjectUtil2.getObjectAttributeByName((Object)target, (String)attributeName);
        if (obj instanceof EFCOption) {
            Class clazz = null;
            try {
                clazz = ClassUtils.getClass((String)((String)this.selectSvc.getOptionClasses().get(attributeName)));
            }
            catch (ClassNotFoundException e) {
                EFCDesktop.reportError(e);
            }
            ((EFCOption)obj).putOptionClass(clazz);
        }
        return obj;
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        return this.data.indexOf(o);
    }

    public int findColumnByField(String fieldName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public int firstIndexOfValue(String column, Object value) {
        int columnid = this.findColumnByField(column);
        if (columnid < 0) {
            throw new IllegalArgumentException("column " + column + " not found in table, available: " + Arrays.toString(this.columns));
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object rowValue = this.getObjectValueAt(i, column);
            if (value == rowValue) {
                return i;
            }
            if (value == null || rowValue == null || !value.equals(rowValue)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectService(SelectService svc) {
        this.selectSvc = svc;
    }

    public SelectService getSelectService() {
        return this.selectSvc;
    }

    public void loadData(Map<String, String> param) {
        if (this.selectSvc == null) {
            throw new NullPointerException("select service is null");
        }
        List columnStrings = this.selectSvc.getFieldNames();
        if (columnStrings == null) {
            throw new RuntimeException("field list of select service is null");
        }
        this.data = this.selectSvc.getElements(param);
        if (EFCDesktop.getCompany() != null && !EFCDesktop.getCompany().isEmpty()) {
            String companyFilter = EFCDesktop.getCompany();
            ListIterator<SelectResult> iter = this.data.listIterator();
            while (iter.hasNext()) {
                SelectResult res = (SelectResult)iter.next();
                String company = (String)res.getKey().get((Object)"COMPANY");
                if (company == null || company.equals(companyFilter)) continue;
                iter.remove();
            }
        }
        if (this.data.size() > 0) {
            this.data.add(new EmptySelectResult());
        }
        Key keyColumns = this.getKeyAt(0);
        ArrayList<String> keyColumnStrings = new ArrayList<String>();
        for (String column : columnStrings) {
            if (keyColumns != null && keyColumns.containsKey((Object)column.toUpperCase())) {
                keyColumnStrings.add(column);
            }
            if (keyColumnStrings.isEmpty() || !column.equalsIgnoreCase("stext")) continue;
            keyColumnStrings.add(column);
        }
        if (!keyColumnStrings.isEmpty()) {
            this.setColumns(keyColumnStrings);
        } else {
            this.setColumns(columnStrings);
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        logger.debug("fireTableDataChanged in SelectServiceTableModel loadData(Map<String, Object> param)");
    }
}

