/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.datatypes.EFCMoney;
import de.effectivecompany.gui.components.model.interfaces.NamedRowsTableModel;
import javax.swing.table.AbstractTableModel;

public class StatisticDataTableModel
extends AbstractTableModel
implements NamedRowsTableModel {
    public static final long serialVersionUID = 9154448275632661823L;
    private StatisticDataObject data;
    private String sidecol = null;
    private String bottomrow = null;
    private Averager averager;
    private Summer summer;

    public StatisticDataTableModel(StatisticDataObject statisticData) {
        this.data = statisticData;
    }

    public StatisticDataTableModel() {
    }

    public StatisticDataObject getData() {
        return this.data;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return EFCMoney.class;
    }

    @Override
    public int getColumnCount() {
        if (this.sidecol == null) {
            return this.data.getGroupCount();
        }
        return this.data.getGroupCount() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.bottomrow == null) {
            return this.data.getDatasetCount();
        }
        return this.data.getDatasetCount() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.getColumnCount() - 1 && rowIndex < this.getRowCount() - 1) {
            return this.data.getValues(rowIndex, columnIndex);
        }
        if (this.sidecol == null) {
            if (rowIndex < this.getRowCount() - 1) {
                return this.data.getValues(rowIndex, columnIndex);
            }
            if (this.bottomrow == null) {
                return this.data.getValues(rowIndex, columnIndex);
            }
            return this.getFinalCellText(rowIndex, columnIndex);
        }
        if (this.bottomrow == null) {
            if (columnIndex < this.getColumnCount() - 1) {
                return this.data.getValues(rowIndex, columnIndex);
            }
            return this.getFinalCellText(rowIndex, columnIndex);
        }
        if (columnIndex == this.getColumnCount() - 1 && rowIndex == this.getRowCount() - 1) {
            double all = 0.0;
            for (int i = 0; i < this.getColumnCount() - 1; ++i) {
                all += Double.parseDouble(this.getFinalCellText(rowIndex, i).toString());
            }
            return all;
        }
        return this.getFinalCellText(rowIndex, columnIndex);
    }

    protected Object getFinalCellText(int rowIndex, int columnIndex) {
        if (rowIndex == this.getRowCount() - 1 && columnIndex == this.getColumnCount() - 1) {
            if (this.sidecol == null && this.bottomrow == null) {
                return "-";
            }
            if (this.bottomrow == null) {
                Funct funct = this.createFunctFromSideCol();
                this.addNumber2Row(rowIndex, funct);
                return funct.get();
            }
            Funct funct = this.createFunctFromBottomCol();
            this.addNumber2Column(columnIndex, funct);
            return funct.get();
        }
        if (rowIndex == this.getRowCount() - 1) {
            Funct funct = this.createFunctFromBottomCol();
            this.addNumber2Column(columnIndex, funct);
            return funct.get();
        }
        Funct funct = this.createFunctFromSideCol();
        this.addNumber2Row(rowIndex, funct);
        return funct.get();
    }

    private void addNumber2Column(int columnIndex, Funct funct) {
        for (int i = 0; i < this.getRowCount() - 1; ++i) {
            if (columnIndex >= this.getColumnCount() - 1) continue;
            this.addNumber(funct, this.data.getValues(i, columnIndex));
        }
    }

    private void addNumber2Row(int rowIndex, Funct funct) {
        for (int i = 0; i < this.getColumnCount() - 1; ++i) {
            if (rowIndex >= this.getRowCount() - 1) continue;
            this.addNumber(funct, this.data.getValues(rowIndex, i));
        }
    }

    private void addNumber(Funct funct, Object o) {
        Number[] number;
        if (o instanceof Number[] && (number = (Number[])o).length > 0 && number[0] != null) {
            funct.add(number[0]);
        }
    }

    private Funct createFunctFromSideCol() {
        Funct funct;
        if (this.sidecol.equals("avg")) {
            if (this.averager == null) {
                this.averager = new Averager();
            } else {
                this.averager.clear();
            }
            funct = this.averager;
        } else {
            if (this.summer == null) {
                this.summer = new Summer();
            } else {
                this.summer.clear();
            }
            funct = this.summer;
        }
        return funct;
    }

    private Funct createFunctFromBottomCol() {
        Funct funct;
        if (this.bottomrow.equals("avg")) {
            if (this.averager == null) {
                this.averager = new Averager();
            } else {
                this.averager.clear();
            }
            funct = this.averager;
        } else {
            if (this.summer == null) {
                this.summer = new Summer();
            } else {
                this.summer.clear();
            }
            funct = this.summer;
        }
        return funct;
    }

    @Override
    public String getColumnName(int column) {
        if (this.sidecol == null) {
            return this.data.getGroupName(column);
        }
        if (column < this.getColumnCount() - 1) {
            return this.data.getGroupName(column);
        }
        if (this.sidecol.equals("avg")) {
            return "\u00d8";
        }
        return "\u03a3";
    }

    @Override
    public String getRowName(int row) {
        if (this.bottomrow == null) {
            return this.data.getDatasetName(row);
        }
        if (row < this.getRowCount() - 1) {
            return this.data.getDatasetName(row);
        }
        if (this.bottomrow.equals("avg")) {
            return "\u00d8";
        }
        return "\u03a3";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setSideBarType(String type) {
        this.sidecol = type;
    }

    public void setBottomBarType(String type) {
        this.bottomrow = type;
    }

    public String getSideBarType() {
        return this.sidecol;
    }

    public String getBottomBarType() {
        return this.bottomrow;
    }

    private class Averager
    extends Funct {
        private double sum;
        private int count;

        private Averager() {
            this.sum = 0.0;
            this.count = 0;
        }

        @Override
        public void add(Number n) {
            this.sum += n.doubleValue();
            ++this.count;
        }

        @Override
        public double get() {
            return this.sum / (double)this.count;
        }

        @Override
        void clear() {
            this.count = 0;
            this.sum = 0.0;
        }
    }

    private class Summer
    extends Funct {
        private double sum;

        private Summer() {
            this.sum = 0.0;
        }

        @Override
        public void add(Number n) {
            this.sum += n.doubleValue();
        }

        @Override
        public double get() {
            return this.sum;
        }

        @Override
        void clear() {
            this.sum = 0.0;
        }
    }

    private abstract class Funct {
        private Funct() {
        }

        abstract void add(Number var1);

        abstract double get();

        abstract void clear();
    }
}

