/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import java.text.MessageFormat;
import java.util.GregorianCalendar;
import org.jfree.chart.labels.IntervalCategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.TaskSeriesCollection;

class CustomToolTipGenerator
extends IntervalCategoryToolTipGenerator {
    private static final long serialVersionUID = 7321170342786566135L;

    public String generateToolTip(CategoryDataset arg0, int arg1, int arg2) {
        return super.generateToolTip(arg0, arg1, arg2);
    }

    public String generateToolTip(CategoryDataset arg0, int arg1, int arg2, int arg3) {
        return this.generateLabelString(arg0, arg1, arg2, arg3);
    }

    protected String generateLabelString(CategoryDataset dataset, int row, int column, int subtask) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result = null;
        Object[] items = this.createItemArray(dataset, row, column, subtask);
        result = MessageFormat.format(this.getLabelFormat(), items);
        return result;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        GregorianCalendar cal = new GregorianCalendar();
        Object[] result = new Object[5];
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        cal.setTimeInMillis(value.longValue());
        result[2] = cal.getTime();
        if (dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
            TaskSeriesCollection collection = (TaskSeriesCollection)icd;
            Number start = collection.getStartValue(row, column);
            Number end = collection.getEndValue(row, column);
            cal.setTimeInMillis(start.longValue());
            result[3] = cal.getTime();
            cal.setTimeInMillis(end.longValue());
            result[4] = cal.getTime();
        }
        return result;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column, int subtask) {
        GregorianCalendar cal = new GregorianCalendar();
        Object[] result = new Object[5];
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        cal.setTimeInMillis(value.longValue());
        result[2] = cal.getTime();
        if (dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
            TaskSeriesCollection collection = (TaskSeriesCollection)icd;
            Number start = collection.getStartValue(row, column, subtask);
            Number end = collection.getEndValue(row, column, subtask);
            cal.setTimeInMillis(start.longValue());
            result[3] = cal.getTime();
            cal.setTimeInMillis(end.longValue());
            result[4] = cal.getTime();
        }
        return result;
    }
}

