/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxStylesheet;
import de.effectivecompany.app.sst.SoBpmGraphEdge;
import de.effectivecompany.app.sst.SoBpmGraphEdgeWayPoint;
import de.effectivecompany.app.sst.SoBpmGraphElement;
import de.effectivecompany.app.sst.SoGraphEdge;
import de.effectivecompany.app.sst.SoGraphElement;
import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.EFCGraphInfo;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCGraphPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.graph.EFCmxCell;
import de.effectivecompany.gui.data.graph.EFCmxGraph;
import de.effectivecompany.gui.data.graph.EFCmxGraphComponent;
import de.effectivecompany.gui.data.graph.Graph;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.events.UserInputEvent;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCBaseViewManager;
import de.effectivecompany.gui.manager.EFCDataChangeManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.ResourceLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCBpmGraphPanel
extends EFCPanel {
    private static final Logger logger = LoggerFactory.getLogger(EFCGraphPanel.class);
    private Hashtable<String, Object> style = new Hashtable();
    private Hashtable<String, Object> styleTask = new Hashtable();
    private Hashtable<String, Object> styleStart = new Hashtable();
    private Hashtable<String, Object> styleEnd = new Hashtable();
    private Hashtable<String, Object> styleExclusivGateway = new Hashtable();
    private Hashtable<String, Object> styleInclusivGateway = new Hashtable();
    private Hashtable<String, Object> styleParallelGateway = new Hashtable();
    private Hashtable<String, Object> edgeStyle = new Hashtable();
    private mxStylesheet stylesheet;
    private EFCGraphInfo infoBox;
    private Double zoomFactor;
    private Rectangle visibleGraph;
    private boolean isDragModus = false;
    public static final long serialVersionUID = -129313190L;
    private EFCmxGraph graph;
    private mxGraphLayout graphLayout;
    private mxGraphView view;
    private mxGraphModel model;
    private EFCmxGraphComponent graphComponent;
    private EFCGlassPanel glass;
    private Graph data = null;
    private List<Object> lastSelection;
    private Vector<UserInputListener> userInputListeners = new Vector();
    private boolean datamodified = false;

    private String addCustomShape(String shapepath) {
        String nodeXml = ResourceLoader.getXmlResource(shapepath);
        int lessthanIndex = nodeXml.indexOf("<");
        nodeXml = nodeXml.substring(lessthanIndex);
        mxStencilShape newShape = new mxStencilShape(nodeXml);
        String name = newShape.getName();
        mxGraphics2DCanvas.putShape((String)name, (mxIShape)newShape);
        return name;
    }

    public EFCBpmGraphPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        EFCPanel.MyFocusHandler focusHandler = new EFCPanel.MyFocusHandler(this);
        MouseEventHandler mouseEventHandler = new MouseEventHandler();
        this.styleTask.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/Task.shape"));
        this.styleTask.put(mxConstants.STYLE_EDITABLE, false);
        this.styleTask.put(mxConstants.STYLE_MOVABLE, false);
        this.styleTask.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleTask.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.styleStart.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/Start-Event.shape"));
        this.styleStart.put(mxConstants.STYLE_EDITABLE, false);
        this.styleStart.put(mxConstants.STYLE_MOVABLE, false);
        this.styleStart.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleStart.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.styleEnd.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/End-Event-Terminate.shape"));
        this.styleEnd.put(mxConstants.STYLE_EDITABLE, false);
        this.styleEnd.put(mxConstants.STYLE_MOVABLE, false);
        this.styleEnd.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleEnd.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.styleExclusivGateway.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/Gateway-Exclusive-XOR-Data-Based.shape"));
        this.styleExclusivGateway.put(mxConstants.STYLE_EDITABLE, false);
        this.styleExclusivGateway.put(mxConstants.STYLE_MOVABLE, false);
        this.styleExclusivGateway.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleExclusivGateway.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.styleInclusivGateway.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/Gateway-Inclusive-OR.shape"));
        this.styleInclusivGateway.put(mxConstants.STYLE_EDITABLE, false);
        this.styleInclusivGateway.put(mxConstants.STYLE_MOVABLE, false);
        this.styleInclusivGateway.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleInclusivGateway.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.styleParallelGateway.put(mxConstants.STYLE_SHAPE, this.addCustomShape("graph/bpmn/Gateway-Parallel-AND.shape"));
        this.styleParallelGateway.put(mxConstants.STYLE_EDITABLE, false);
        this.styleParallelGateway.put(mxConstants.STYLE_MOVABLE, false);
        this.styleParallelGateway.put(mxConstants.STYLE_RESIZABLE, false);
        this.styleParallelGateway.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.style.put(mxConstants.STYLE_SHAPE, "label");
        this.style.put(mxConstants.STYLE_EDITABLE, false);
        this.style.put(mxConstants.STYLE_MOVABLE, false);
        this.style.put(mxConstants.STYLE_RESIZABLE, false);
        this.style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        this.edgeStyle.put(mxConstants.STYLE_ROUNDED, true);
        this.edgeStyle.put(mxConstants.STYLE_EDITABLE, false);
        this.edgeStyle.put(mxConstants.STYLE_MOVABLE, false);
        this.edgeStyle.put(mxConstants.STYLE_BENDABLE, false);
        this.edgeStyle.put(mxConstants.STYLE_PORT_CONSTRAINT, 15);
        this.edgeStyle.put(mxConstants.STYLE_STROKEWIDTH, 2.0);
        this.model = new mxGraphModel();
        this.graph = new EFCmxGraph((mxIGraphModel)this.model);
        this.graph.setHtmlLabels(true);
        this.view = new mxGraphView((mxGraph)this.graph);
        this.stylesheet = this.graph.getStylesheet();
        this.stylesheet.putCellStyle("elementStyle", this.style);
        this.stylesheet.putCellStyle("edgeStyle", this.edgeStyle);
        this.stylesheet.putCellStyle("styleTask", this.styleTask);
        this.stylesheet.putCellStyle("styleStart", this.styleStart);
        this.stylesheet.putCellStyle("styleEnd", this.styleEnd);
        this.stylesheet.putCellStyle("styleExclusivGateway", this.styleExclusivGateway);
        this.stylesheet.putCellStyle("styleInclusivGateway", this.styleInclusivGateway);
        this.stylesheet.putCellStyle("styleParallelGateway", this.styleParallelGateway);
        this.graphComponent = new EFCmxGraphComponent(this.graph);
        this.graphComponent.setToolTips(true);
        this.graphComponent.setAntiAlias(true);
        this.graphComponent.setCenterPage(true);
        this.graphComponent.setConnectable(false);
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)mouseEventHandler);
        this.graphComponent.getGraphControl().addMouseMotionListener((MouseMotionListener)mouseEventHandler);
        this.graphComponent.getGraphControl().addMouseWheelListener((MouseWheelListener)mouseEventHandler);
        this.graphComponent.getGraphControl().addFocusListener((FocusListener)focusHandler);
        this.graphComponent.getGraphHandler().setRemoveCellsFromParent(false);
        this.glass = new EFCGlassPanel((Container)((Object)this.graphComponent));
        this.add(this.glass);
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    public void fireUserInputEvent(String id, InputEvent event) {
        int type = 0;
        switch (event.getID()) {
            case 501: {
                type = 2059;
                break;
            }
            case 507: {
                type = 2060;
                break;
            }
            case 401: {
                type = 2061;
                break;
            }
            case 400: {
                type = 2062;
                break;
            }
            case 402: {
                type = 2063;
            }
        }
        if (type == 0) {
            return;
        }
        UserInputEvent uie = new UserInputEvent(this, type, event, this.getIdent());
        for (UserInputListener l : this.getUserInputListeners()) {
            l.onUserInput(uie);
        }
    }

    public void setData(Graph data) {
        this.data = data;
        this.datamodified = true;
        this.visibleGraph = this.graphComponent.getGraphControl().getVisibleRect();
        this.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadData() {
        ((mxGraphModel)this.graph.getModel()).clear();
        Object parent = this.graph.getDefaultParent();
        HashMap<String, mxCell> elementMap = new HashMap<String, mxCell>();
        ArrayList<mxCell> elementList = new ArrayList<mxCell>();
        ArrayList<mxCell> edgeList = new ArrayList<mxCell>();
        if (this.data == null) {
            return;
        }
        this.graph.getModel().beginUpdate();
        try {
            if (this.data.getElements() != null && !this.data.getElements().isEmpty()) {
                for (SoGraphElement element : this.data.getElements()) {
                    mxCell vertexElement = (mxCell)this.createVertexElement(parent, (SoBpmGraphElement)element);
                    elementMap.put(element.getElementid().getData(), vertexElement);
                    elementList.add(vertexElement);
                }
                for (SoGraphEdge edge : this.data.getEdges()) {
                    mxGeometry geometryOfEdge;
                    ArrayList<mxPoint> pointsOfTheEdge;
                    Object start = null;
                    Object end = null;
                    if (elementMap.containsKey(edge.getSourceid().getData())) {
                        start = elementMap.get(edge.getSourceid().getData());
                    }
                    if (elementMap.containsKey(edge.getTargetid().getData())) {
                        end = elementMap.get(edge.getTargetid().getData());
                    }
                    if (start == null || end == null) continue;
                    mxCell mxEdge = (mxCell)this.graph.insertEdge(parent, null, ((SoBpmGraphEdge)edge).getStext(), start, end, "edgeStyle");
                    edgeList.add(mxEdge);
                    if (((SoBpmGraphEdge)edge).getColor() != null) {
                        this.graph.setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)((SoBpmGraphEdge)edge).getColor()), new Object[]{mxEdge});
                    }
                    if ((pointsOfTheEdge = (geometryOfEdge = mxEdge.getGeometry()).getPoints()) == null) {
                        pointsOfTheEdge = new ArrayList<mxPoint>();
                    }
                    for (SoBpmGraphEdgeWayPoint point : ((SoBpmGraphEdge)edge).getWaypoints()) {
                        pointsOfTheEdge.add(new mxPoint(point.getX().getData().doubleValue(), point.getY().getData().doubleValue()));
                    }
                    geometryOfEdge.setPoints(pointsOfTheEdge);
                    mxEdge.setGeometry(geometryOfEdge);
                }
                this.graphLayout = new mxHierarchicalLayout((mxGraph)this.graph);
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        if (this.visibleGraph != null && this.zoomFactor != null) {
            this.graphComponent.getGraphControl().scrollRectToVisible(this.visibleGraph);
            this.graphComponent.zoom(this.zoomFactor);
        } else {
            mxGraphView view = this.graphComponent.getGraph().getView();
            int compLen = this.graphComponent.getWidth();
            int viewLen = (int)view.getGraphBounds().getWidth();
            view.setScale((double)compLen / (double)viewLen * view.getScale());
        }
        this.repaint();
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void loadData() {
        LazyLoader loader;
        if (this.data instanceof LazyLoader && !(loader = (LazyLoader)this.data).isLoaded()) {
            this.setLocked(true);
            EFCThreadUtil.edtBuilder(th -> {
                this.setLocked(true);
                th.doOutside(() -> {
                    LazyLoader loadData = null;
                    if (this.data instanceof LazyLoader) {
                        loadData = (LazyLoader)this.data;
                    }
                    if (loadData != null) {
                        loadData.lock();
                        if (!loadData.isLoaded()) {
                            try {
                                loadData.load();
                            }
                            catch (Exception e) {
                                logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                            }
                        }
                        loadData.unlock();
                    }
                    th.edt(() -> {
                        try {
                            this.reloadData();
                        }
                        catch (Throwable e) {
                            EFCDesktop.reportError(e);
                        }
                        this.setLocked(false);
                        this.repaint();
                    });
                });
            });
        }
        this.datamodified = false;
    }

    public List<SoBpmGraphElement> getSelectedElements() {
        return this.buildElementList(this.graph.getSelectionCells());
    }

    private List<SoBpmGraphElement> buildElementList(List<Object> cells) {
        if (cells == null) {
            return null;
        }
        return this.buildElementList(cells.toArray());
    }

    private List<SoBpmGraphElement> buildElementList(Object[] cells) {
        if (cells == null) {
            return null;
        }
        LinkedList<SoBpmGraphElement> elements = new LinkedList<SoBpmGraphElement>();
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof EFCmxCell)) continue;
            EFCmxCell cell = (EFCmxCell)((Object)cells[i]);
            Object userObject = cell.getValue();
            if (userObject instanceof SoBpmGraphElement) {
                elements.add((SoBpmGraphElement)userObject);
                continue;
            }
            SoBpmGraphElement e = new SoBpmGraphElement(new EFCString(userObject.toString()));
            e.setBo(cell.getBusinessObject());
            elements.add(e);
        }
        return elements;
    }

    private Object createVertexElement(Object parent, SoBpmGraphElement element) {
        Object vertexElement = null;
        if (element.getElementtype() != null && element.getElementtype().getData() != null) {
            String style = "elementStyle";
            switch (element.getElementtype().getData()) {
                case 10: {
                    style = "styleStart";
                    break;
                }
                case 20: {
                    style = "styleEnd";
                    break;
                }
                case 40: {
                    style = "styleTask";
                    break;
                }
                case 60: {
                    style = "styleExclusivGateway";
                    break;
                }
                case 70: {
                    style = "styleInclusivGateway";
                    break;
                }
                case 50: {
                    style = "styleParallelGateway";
                }
            }
            vertexElement = this.graph.insertVertex(parent, null, element.getStext().getData(), element.getX().getData(), element.getY().getData(), element.getWidth().getData(), element.getHeight().getData(), style, element.getBo(), element.getTooltip().getData());
        } else {
            vertexElement = this.graph.insertVertex(parent, null, element.getStext().getData(), element.getX().getData(), element.getY().getData(), element.getWidth().getData(), element.getHeight().getData(), "elementStyle", element.getBo(), element.getTooltip().getData());
        }
        if (element.getColor() != null) {
            this.graphComponent.selectCellForEvent(vertexElement, null);
            this.graph.setCellStyles(mxConstants.STYLE_FILLCOLOR, mxUtils.hexString((Color)element.getColor()));
            this.graphComponent.selectCellForEvent(null, null);
        }
        if (element.getImage() != null && element.getImage().getData() != null && !element.getImage().getData().isEmpty()) {
            if (!this.stylesheet.getStyles().containsKey(element.getImage())) {
                Hashtable<String, Object> imageStyle = new Hashtable<String, Object>();
                imageStyle.put(mxConstants.STYLE_SHAPE, "label");
                imageStyle.put(mxConstants.STYLE_EDITABLE, false);
                imageStyle.put(mxConstants.STYLE_MOVABLE, false);
                imageStyle.put(mxConstants.STYLE_RESIZABLE, false);
                ImageIcon icon = ResourceLoader.getImageIconResource("/png/" + element.getImage());
                if (icon != null) {
                    imageStyle.put("image", icon);
                }
                this.stylesheet.putCellStyle(element.getImage().getData(), imageStyle);
                ((EFCmxCell)((Object)vertexElement)).setStyle(((EFCmxCell)((Object)vertexElement)).getStyle() + ";" + element.getImage());
            } else {
                ((EFCmxCell)((Object)vertexElement)).setStyle(((EFCmxCell)((Object)vertexElement)).getStyle() + ";" + element.getImage());
            }
        }
        if (element.getPriority() != null) {
            Integer prio = element.getPriority().getData();
            this.graphComponent.selectCellForEvent(vertexElement, null);
            this.graph.setCellStyles(mxConstants.STYLE_STROKECOLOR, mxUtils.hexString((Color)Color.BLACK), new Object[]{vertexElement});
            this.graph.setCellStyles(mxConstants.STYLE_STROKEWIDTH, prio != null ? prio.toString() : "", new Object[]{vertexElement});
            this.graphComponent.selectCellForEvent(null, null);
        }
        return vertexElement;
    }

    @Override
    public void paint(Graphics g) {
        if (this.datamodified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public void terminate() {
        for (MouseListener mouseListener : this.graphComponent.getMouseListeners()) {
            this.graphComponent.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.graphComponent.getMouseMotionListeners()) {
            this.graphComponent.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.graphComponent.getMouseWheelListeners()) {
            this.graphComponent.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.graphComponent.getFocusListeners()) {
            this.graphComponent.removeFocusListener((FocusListener)eventListener);
        }
        if (this.infoBox != null) {
            this.infoBox.dispose();
        }
        this.userInputListeners.clear();
        this.removeAll();
        this.graph = null;
        this.userInputListeners = null;
        this.view = null;
        this.glass = null;
        this.data = null;
        this.style.clear();
        this.style = null;
        this.edgeStyle.clear();
        this.edgeStyle = null;
        this.stylesheet = null;
        this.infoBox = null;
        super.terminate();
    }

    private class MouseEventHandler
    extends MouseAdapter {
        private MouseEventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EFCmxCell graphCell;
            if ((e.getButton() == 3 || e.getButton() == 1 && EFCBpmGraphPanel.this.infoBox != null) && e.getSource() instanceof mxGraphComponent.mxGraphControl && EFCBpmGraphPanel.this.graph.getSelectionCell() instanceof EFCmxCell && EFCBpmGraphPanel.this.graph.getSelectionCell() instanceof EFCmxCell && (graphCell = (EFCmxCell)((Object)EFCBpmGraphPanel.this.graph.getSelectionCell())) != null && graphCell.getBusinessObject() != null) {
                if (EFCBpmGraphPanel.this.infoBox == null) {
                    EFCBpmGraphPanel.this.infoBox = new EFCGraphInfo(EFCBpmGraphPanel.this, new EFCBaseViewManager(), new EFCDataChangeManager(), graphCell.getBusinessObject());
                    EFCDesktop.getInstance().add(EFCBpmGraphPanel.this.infoBox);
                }
                EFCBpmGraphPanel.this.infoBox.setBoData(graphCell.getBusinessObject());
                EFCBpmGraphPanel.this.infoBox.setVisible(true);
                EFCBpmGraphPanel.this.infoBox.toFront();
            }
            EFCBpmGraphPanel.this.fireUserInputEvent(EFCBpmGraphPanel.this.getIdent(), e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            List<Object> oldSelection = EFCBpmGraphPanel.this.lastSelection;
            List<Object> newSelection = Arrays.asList(EFCBpmGraphPanel.this.graph.getSelectionCells());
            EFCBpmGraphPanel src = EFCBpmGraphPanel.this;
            int eventId = 2085;
            if (newSelection.size() == 0 && (oldSelection == null || oldSelection.size() == 0)) {
                return;
            }
            if (oldSelection != null && newSelection.containsAll(oldSelection) && oldSelection.containsAll(newSelection)) {
                return;
            }
            SelectionContextChangeEvent sece = new SelectionContextChangeEvent(src, eventId, EFCBpmGraphPanel.this.getIdent(), EFCBpmGraphPanel.this.buildElementList(oldSelection), EFCBpmGraphPanel.this.buildElementList(newSelection));
            sece.setSelected(EFCBpmGraphPanel.this.buildElementList(newSelection));
            BusinessObject oldSelectionBusObj = null;
            BusinessObject newSelectionBusObj = null;
            if (oldSelection != null && oldSelection.size() > 0 && oldSelection.get(0) instanceof EFCmxCell) {
                oldSelectionBusObj = ((EFCmxCell)((Object)oldSelection.get(0))).getBusinessObject();
            }
            if (newSelection != null && newSelection.size() > 0 && newSelection.get(0) instanceof EFCmxCell) {
                newSelectionBusObj = ((EFCmxCell)((Object)newSelection.get(0))).getBusinessObject();
            }
            SelectionContextChangeEvent seceBusObj = new SelectionContextChangeEvent(src, eventId, EFCBpmGraphPanel.this.getIdent(), oldSelectionBusObj, newSelectionBusObj);
            seceBusObj.setSelected(newSelectionBusObj);
            DataChangeManager dcm = EFCBpmGraphPanel.this.getDataChangeManager();
            if (dcm != null) {
                dcm.onSelectionContextChanged(sece);
                dcm.onSelectionContextChanged(seceBusObj);
            }
            EFCBpmGraphPanel.this.lastSelection = newSelection;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            double d = EFCBpmGraphPanel.this.view.getScale();
            double rot = event.getWheelRotation();
            if ((d += 0.1 * rot) < 0.25) {
                d = 0.25;
            }
            if (d > 2.0) {
                d = 2.0;
            }
            EFCBpmGraphPanel.this.zoomFactor = d;
            EFCBpmGraphPanel.this.graphComponent.zoom(EFCBpmGraphPanel.this.zoomFactor);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            EFCBpmGraphPanel.this.isDragModus = SwingUtilities.isLeftMouseButton(e);
        }
    }
}

