/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.interfaces.frame.EFCView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EFCButtonPanel
extends JPanel {
    private static final long serialVersionUID = -1695243244756293765L;
    private List<JButton> buttons = new ArrayList<JButton>();
    private EFCView view;

    public EFCButtonPanel(String[] buttonNames, EFCView view) {
        this.view = view;
        this.createButtonPanel(buttonNames);
    }

    private void createButtonPanel(String[] buttonNames) {
        this.createButtons(buttonNames);
        this.createButtonLayout();
    }

    private void createButtons(String[] buttonNames) {
        for (int i = 0; i < buttonNames.length; ++i) {
            JButton button = new JButton(buttonNames[i]);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EFCButtonPanel.this.view.getController().onDialogButtonClicked(EFCButtonPanel.this.getButtonNumber(event));
                }
            });
            this.buttons.add(button);
        }
    }

    private int getButtonNumber(ActionEvent event) {
        for (JButton button : this.buttons) {
            if (!button.getText().equals(event.getActionCommand())) continue;
            return this.buttons.indexOf(button);
        }
        return 0;
    }

    private void createButtonLayout() {
        for (JButton button : this.buttons) {
            this.add(button);
        }
    }

    public JButton getButton(int buttonNumber) {
        if (buttonNumber < this.buttons.size()) {
            return this.buttons.get(buttonNumber);
        }
        return null;
    }

    public void terminate() {
        this.removeAll();
        this.buttons = null;
        this.view = null;
    }
}

