/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.chart.StatisticDiagramDataset;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.StatisticPanel;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;

public class EFCDiagramPanel
extends EFCPanel
implements StatisticPanel {
    private static final long serialVersionUID = -7232345L;
    private ChartPanel chartPanel = new ChartPanel(null);
    private String type;
    private EFCGlassPanel glass = new EFCGlassPanel((Container)this.chartPanel);
    private StatisticDataObject dataObject;
    private boolean dataModified = false;

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public EFCDiagramPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.add(this.glass);
    }

    @Override
    public void setDataSource(StatisticDataObject statdata) {
        this.dataObject = statdata;
        this.dataModified = true;
    }

    private void loadData() {
        if (this.dataObject != null) {
            this.setLocked(true);
            new LoaderRunner(this.dataObject).execute();
        }
        this.dataModified = false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.chartPanel = null;
        this.dataObject = null;
        this.glass = null;
        super.terminate();
    }

    private class LoaderRunner
    extends SwingWorker<JFreeChart, Object> {
        private StatisticDataObject data2load;

        public LoaderRunner(StatisticDataObject data) {
            this.data2load = data;
        }

        @Override
        protected JFreeChart doInBackground() {
            this.data2load.lock();
            if (this.data2load instanceof LazyLoader) {
                try {
                    LazyLoader lazyLoader = (LazyLoader)this.data2load;
                    if (!lazyLoader.isLoaded()) {
                        lazyLoader.load();
                    }
                }
                catch (Throwable e) {
                    EFCDesktop.reportError(e);
                }
            }
            this.data2load.unlock();
            String axis1 = Translator.tr((String)this.data2load.getGroupHeading());
            String axis2 = Translator.tr((String)this.data2load.getValueHeading());
            String title = Translator.tr((String)this.data2load.getTitle());
            if (EFCDiagramPanel.this.type == null) {
                return ChartFactory.createLineChart((String)EFCDiagramPanel.this.getIdent(), (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("pie")) {
                return ChartFactory.createPieChart((String)title, (PieDataset)new StatisticDiagramDataset(this.data2load), (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("pie3D")) {
                return ChartFactory.createPieChart3D((String)title, (PieDataset)new StatisticDiagramDataset(this.data2load), (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("line")) {
                return ChartFactory.createLineChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("line3D")) {
                return ChartFactory.createLineChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("bar")) {
                return ChartFactory.createBarChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("bar3D")) {
                return ChartFactory.createBarChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("stackedbar")) {
                return ChartFactory.createStackedBarChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            if (EFCDiagramPanel.this.type.equalsIgnoreCase("stackedbar3D")) {
                return ChartFactory.createStackedBarChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            }
            return ChartFactory.createLineChart((String)title, (String)axis1, (String)axis2, (CategoryDataset)new StatisticDiagramDataset(this.data2load), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        }

        @Override
        protected void done() {
            try {
                JFreeChart ch = (JFreeChart)this.get();
                EFCDiagramPanel.this.chartPanel.setChart(ch);
                EFCDiagramPanel.this.setLocked(false);
            }
            catch (InterruptedException | ExecutionException e) {
                EFCDesktop.reportError(e);
            }
        }
    }
}

