/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.model.interfaces.TreeModel;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.ETreeRenderer;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeElement;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeModel;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.events.UserInputEvent;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCExplorerPanel
extends EFCPanel {
    private static Logger logger = LoggerFactory.getLogger(EFCExplorerPanel.class);
    public static final long serialVersionUID = -7232345L;
    private Object lastSelectedObject;
    private JTree panel = new JTree();
    private ETreeModel model = new ETreeModel();
    protected TreeModel data;
    private Vector<UserInputListener> userInputListeners = new Vector();
    private boolean dataModified = false;
    private EFCGlassPanel glass = new EFCGlassPanel(new JScrollPane(this.panel));

    public EFCExplorerPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        SelectionHandler selectionHandler = new SelectionHandler();
        UserInputHandler inputHandler = new UserInputHandler();
        EFCPanel.MyFocusHandler focusHandler = new EFCPanel.MyFocusHandler(this);
        this.panel.setCellRenderer(new ETreeRenderer());
        this.panel.setModel(this.model);
        this.panel.addTreeSelectionListener(selectionHandler);
        this.panel.addKeyListener(inputHandler);
        this.panel.addMouseListener(inputHandler);
        this.panel.addMouseWheelListener(inputHandler);
        this.panel.addFocusListener(focusHandler);
        this.add((Component)this.glass, "Center");
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    public void fireUserInputEvent(String id, InputEvent event) {
        int type = 0;
        switch (event.getID()) {
            case 501: {
                type = 2059;
                break;
            }
            case 507: {
                type = 2060;
                break;
            }
            case 401: {
                type = 2061;
                break;
            }
            case 400: {
                type = 2062;
                break;
            }
            case 402: {
                type = 2063;
            }
        }
        if (type == 0) {
            return;
        }
        UserInputEvent uie = new UserInputEvent(this, type, event, this.getIdent());
        for (UserInputListener l : this.getUserInputListeners()) {
            l.onUserInput(uie);
        }
    }

    public void setData(TreeModel root) {
        this.data = root;
        this.dataModified = false;
        if (this.data instanceof LazyLoader) {
            this.dataModified = true;
            this.model.setRoot(null);
        } else {
            this.model.setRoot(root.getRoot());
        }
    }

    public TreeModel getData() {
        return this.data;
    }

    public ETreeElement getSelectedElement() {
        Object o = null;
        if (this.panel.getSelectionPath() != null) {
            o = this.panel.getSelectionPath().getLastPathComponent();
        }
        if (o instanceof ETreeElement) {
            return (ETreeElement)o;
        }
        return null;
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void checkForLoading() {
        LazyLoader loader;
        TreeModel object = this.getData();
        if (object == null) {
            logger.warn("tree data is null");
        }
        if (object instanceof LazyLoader && !(loader = (LazyLoader)object).isLoaded()) {
            this.setLocked(true);
            EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                AtomicBoolean didLoading = new AtomicBoolean(false);
                LazyLoader lazyLoader = (LazyLoader)this.getData();
                lazyLoader.lock();
                try {
                    if (lazyLoader.isLoaded()) {
                        lazyLoader.unlock();
                    }
                    try {
                        this.setEnabled(false);
                        lazyLoader.load();
                        didLoading.set(true);
                    }
                    catch (Throwable ex) {
                        EFCDesktop.reportError(ex);
                    }
                }
                catch (Exception e) {
                    logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                }
                lazyLoader.unlock();
                th.edt(() -> {
                    if (didLoading.get()) {
                        this.setEnabled(true);
                        this.model.setRoot(this.data.getRoot());
                    }
                    this.setLocked(false);
                });
            }));
        }
        this.dataModified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.checkForLoading();
        }
        super.paint(g);
    }

    @Override
    public void terminate() {
        for (TreeSelectionListener treeSelectionListener : this.panel.getTreeSelectionListeners()) {
            this.panel.removeTreeSelectionListener(treeSelectionListener);
        }
        for (EventListener eventListener : this.panel.getKeyListeners()) {
            this.panel.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : this.panel.getMouseListeners()) {
            this.panel.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.panel.getMouseWheelListeners()) {
            this.panel.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.panel.getFocusListeners()) {
            this.panel.removeFocusListener((FocusListener)eventListener);
        }
        this.data = null;
        this.model = null;
        this.userInputListeners.clear();
        this.userInputListeners = null;
        this.removeAll();
        this.panel = null;
        super.terminate();
    }

    private class UserInputHandler
    extends MouseAdapter
    implements KeyListener {
        private UserInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            EFCExplorerPanel.this.fireUserInputEvent(EFCExplorerPanel.this.getIdent(), e);
        }
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object fromObj = EFCExplorerPanel.this.lastSelectedObject;
            ETreeElement toObj = EFCExplorerPanel.this.getSelectedElement();
            DataChangeManager dcm = EFCExplorerPanel.this.getDataChangeManager();
            if (dcm != null) {
                dcm.onSelectionContextChanged(new SelectionContextChangeEvent(EFCExplorerPanel.this, 2082, EFCExplorerPanel.this.getIdent(), fromObj, toObj));
            }
            EFCExplorerPanel.this.lastSelectedObject = toObj;
        }
    }
}

