/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class EFCFormPanel
extends EFCPanel {
    public static final long serialVersionUID = -425134562L;
    private FormLayout layout = new FormLayout("3dlu", "3dlu");
    private PanelBuilder panelBuilder;
    private static CellConstraints cc = new CellConstraints();

    public EFCFormPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        this.panelBuilder = new PanelBuilder(this.layout, (JPanel)this);
        this.panelBuilder.background(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
    }

    public EFCFormPanel(String ident, String parentIdent, boolean border) {
        super(ident, parentIdent, border);
        this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        this.panelBuilder = new PanelBuilder(this.layout, (JPanel)this);
        this.panelBuilder.background(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
    }

    public Component addAtLocation(EditorComponent component, int x, int y, int width, int height) {
        if (component instanceof JComponent) {
            return this.addAtLocation((JComponent)((Object)component), x, y, width, height);
        }
        return null;
    }

    private int spreadW(int spread) {
        if (spread == 1) {
            return 1;
        }
        return 1 + (spread - 1) * 4;
    }

    private int spreadWForText(int spread) {
        if (spread == 1) {
            return 1;
        }
        return 1 + (spread - 1) * 2;
    }

    private int spreadV(int spread) {
        if (spread == 1) {
            return 1;
        }
        return spread * 2 - 1;
    }

    public Component addAtLocation(JComponent component, int x, int y, int width, int height) {
        while (x * 4 + this.spreadW(width) > this.panelBuilder.getColumnCount()) {
            this.createColumnLayout();
        }
        while (y * 2 + this.spreadV(height) > this.panelBuilder.getRowCount()) {
            this.createRowLayout();
        }
        if (width > 1 || height > 1) {
            return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, this.spreadW(width), this.spreadV(height), CellConstraints.FILL, CellConstraints.FILL));
        }
        return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, this.spreadW(width), this.spreadV(height), CellConstraints.LEFT, CellConstraints.TOP));
    }

    public Component addAtAbsouluteLocation(JComponent component, int x, int y, int width, int height) {
        while (x * 4 + this.spreadWForText(width) > this.panelBuilder.getColumnCount()) {
            this.createColumnLayout();
        }
        while (y * 2 + this.spreadV(height) > this.panelBuilder.getRowCount()) {
            this.createRowLayout();
        }
        if (width > 1 || height > 1) {
            return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, this.spreadWForText(width), this.spreadV(height), CellConstraints.FILL, CellConstraints.FILL));
        }
        return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, this.spreadWForText(width), this.spreadV(height), CellConstraints.LEFT, CellConstraints.TOP));
    }

    public Component addAbsoulute(JComponent component, int x, int y, int width, int height) {
        while (x * 4 + width > this.panelBuilder.getColumnCount()) {
            this.createColumnLayout();
        }
        while (y * 2 + height > this.panelBuilder.getRowCount()) {
            this.createRowLayout();
        }
        if (width > 1 || height > 1) {
            return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, width, height, CellConstraints.FILL, CellConstraints.FILL));
        }
        return this.panelBuilder.add((Component)component, cc.xywh(x * 2, y * 2, width, height, CellConstraints.LEFT, CellConstraints.TOP));
    }

    public void clearComponents() {
        this.panelBuilder.getPanel().removeAll();
        this.panelBuilder.getPanel().revalidate();
        this.panelBuilder.getPanel().repaint();
    }

    public Component addSeparator(String text, int x, int y, int width, int height) {
        JXTitledSeparator separator = new JXTitledSeparator(text);
        while (x * 4 + this.spreadW(width) > this.panelBuilder.getColumnCount()) {
            this.createColumnLayout();
        }
        while (y * 2 + this.spreadV(height) > this.panelBuilder.getRowCount()) {
            this.createRowLayout();
        }
        if (width > 1 || height > 1) {
            this.panelBuilder.add((Component)separator, cc.xywh(x * 2, y * 2, this.spreadW(width) + 2, this.spreadV(height), CellConstraints.FILL, CellConstraints.FILL));
        } else {
            this.panelBuilder.add((Component)separator, cc.xywh(x * 2, y * 2, this.spreadW(width) + 2, this.spreadV(height), CellConstraints.FILL, CellConstraints.TOP));
        }
        return separator;
    }

    private void createColumnLayout() {
        this.layout.appendColumn(EFCLookAndFeelManager.SIZE_COL_LABEL);
        this.layout.appendColumn(EFCLookAndFeelManager.SIZE_COL_LABELDATASPACE);
        this.layout.appendColumn(EFCLookAndFeelManager.SIZE_COL_DATA);
        this.layout.appendColumn(EFCLookAndFeelManager.SIZE_COL_NEXTCOLSPACE);
    }

    private void createRowLayout() {
        this.layout.appendRow(EFCLookAndFeelManager.SIZE_ROW_DATA);
        this.layout.appendRow(EFCLookAndFeelManager.SIZE_ROW_SPACE);
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.layout = null;
        this.panelBuilder = null;
        super.terminate();
    }
}

