/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.app.sst.SoGanttData;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gantt.GanttListener;
import de.effectivecompany.gantt.GanttView;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.events.DragEvent;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGanttPanel
extends EFCPanel
implements GanttListener {
    private static final Logger logger = LoggerFactory.getLogger(EFCGanttPanel.class);
    private EFCMap<String, BusinessObject> nodeMap = new EFCMap();
    public static final long serialVersionUID = -129313190L;
    private Vector<UserInputListener> userInputListeners = new Vector();
    private GanttView panel = new GanttView();
    private boolean datamodified = false;

    public EFCGanttPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.panel.addGanttLIstener(this);
        this.add((Component)this.panel, "Center");
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    public void setData(SoGanttData data) {
        this.nodeMap.clear();
        if (data != null) {
            data.getDatasetList().forEach(dataset -> dataset.getTaskList().forEach(task -> {
                if (task.getBo() != null && task.getId().getData() != null) {
                    this.nodeMap.put((Object)task.getId().getData(), (Object)task.getBo());
                }
            }));
        }
        this.panel.setData(data);
    }

    public void reloadData() {
        this.nodeMap.clear();
    }

    private void loadData() {
        this.datamodified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.datamodified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public void terminate() {
        this.panel.terminate();
        this.nodeMap.clear();
        this.nodeMap = null;
        this.userInputListeners.clear();
        this.removeAll();
        this.userInputListeners = null;
        super.terminate();
    }

    @Override
    public void onSelection(String mouse, String id) {
        BusinessObject selectedBusObj = (BusinessObject)this.nodeMap.get((Object)id);
        SelectionContextChangeEvent seceBusObj = new SelectionContextChangeEvent(this, 2083, this.getIdent(), null, selectedBusObj);
        seceBusObj.setSelected(selectedBusObj);
        DataChangeManager dcm = this.getDataChangeManager();
        if (dcm != null) {
            dcm.onSelectionContextChanged(seceBusObj);
        }
    }

    public void setLocked(boolean locked) {
        EFCThreadUtil.doLater(() -> this.panel.setLocked(locked));
    }

    @Override
    public void onDragEnd(String id, String resource, Date newStart, Date newEnd, Date min, Date max, Map<String, List<Date>> liveMovedElements) {
        BusinessObject selectedBusObj = (BusinessObject)this.nodeMap.get((Object)id);
        HashMap<BusinessObject, List<Date>> liveMovedElementsMap = new HashMap<BusinessObject, List<Date>>();
        liveMovedElements.forEach((key, value) -> liveMovedElementsMap.put((BusinessObject)this.nodeMap.get(key), (List<Date>)value));
        DragEvent dragEvent = new DragEvent(this, 2089, this.getIdent(), selectedBusObj, resource, newStart, newEnd, min, max, liveMovedElementsMap);
        DataChangeManager dcm = this.getDataChangeManager();
        if (dcm != null) {
            dcm.onDrag(dragEvent);
        }
    }
}

