/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.components.panel.CustomToolTipGenerator;
import de.effectivecompany.gui.components.panel.EFCCategoryItemEntity;
import de.effectivecompany.gui.components.swing.gantt.EFCTask;
import de.effectivecompany.gui.data.gantt.EFCTaskSeriesCollection;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;

class EFCGanttRenderer
extends GanttRenderer {
    private static final long serialVersionUID = 1L;

    protected void drawTasks(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, GanttCategoryDataset dataset, int row, int column) {
        EFCTaskSeriesCollection collection = (EFCTaskSeriesCollection)dataset;
        int count = collection.getSubIntervalCount(row, column);
        if (count == 0) {
            this.drawTask(g2, state, dataArea, plot, domainAxis, rangeAxis, (GanttCategoryDataset)collection, row, column);
        }
        PlotOrientation orientation = plot.getOrientation();
        for (int subinterval = 0; subinterval < count; ++subinterval) {
            EntityCollection entities;
            Number value0;
            EFCTask task = null;
            RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
            if (collection.getTask(row, column, subinterval) instanceof EFCTask) {
                task = (EFCTask)collection.getTask(row, column, subinterval);
            }
            if ((value0 = collection.getStartValue(row, column, subinterval)) == null) {
                return;
            }
            double translatedValue0 = rangeAxis.valueToJava2D(value0.doubleValue(), dataArea, rangeAxisLocation);
            Number value1 = collection.getEndValue(row, column, subinterval);
            if (value1 == null) {
                return;
            }
            double translatedValue1 = rangeAxis.valueToJava2D(value1.doubleValue(), dataArea, rangeAxisLocation);
            if (translatedValue1 < translatedValue0) {
                double temp = translatedValue1;
                translatedValue1 = translatedValue0;
                translatedValue0 = temp;
            }
            double rectBreadth = 15.0;
            if (task.getSizeMultiplier() != null) {
                rectBreadth *= task.getSizeMultiplier().doubleValue();
            }
            double rectStart = domainAxis.getCategoryJava2DCoordinate(CategoryAnchor.MIDDLE, column, plot.getCategories().size(), dataArea, plot.getDomainAxisEdge()) - rectBreadth / 2.0;
            double rectLength = Math.abs(translatedValue1 - translatedValue0);
            Rectangle2D.Double bar = null;
            RectangleEdge barBase = null;
            if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                bar = new Rectangle2D.Double(translatedValue0, rectStart, rectLength, rectBreadth);
                barBase = RectangleEdge.LEFT;
            } else if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                bar = new Rectangle2D.Double(rectStart, translatedValue0, rectBreadth, rectLength);
                barBase = RectangleEdge.BOTTOM;
            }
            Rectangle2D.Double completeBar = null;
            Rectangle2D.Double incompleteBar = null;
            Number percent = collection.getPercentComplete(row, column, subinterval);
            double start = this.getStartPercent();
            double end = this.getEndPercent();
            if (percent != null) {
                double p = percent.doubleValue();
                if (orientation == PlotOrientation.HORIZONTAL) {
                    completeBar = new Rectangle2D.Double(translatedValue0, rectStart + start * rectBreadth, rectLength * p, rectBreadth * (end - start));
                    incompleteBar = new Rectangle2D.Double(translatedValue0 + rectLength * p, rectStart + start * rectBreadth, rectLength * (1.0 - p), rectBreadth * (end - start));
                } else if (orientation == PlotOrientation.VERTICAL) {
                    completeBar = new Rectangle2D.Double(rectStart + start * rectBreadth, translatedValue0 + rectLength * (1.0 - p), rectBreadth * (end - start), rectLength * p);
                    incompleteBar = new Rectangle2D.Double(rectStart + start * rectBreadth, translatedValue0, rectBreadth * (end - start), rectLength * (1.0 - p));
                }
            }
            if (this.getShadowsVisible()) {
                this.getBarPainter().paintBarShadow(g2, (BarRenderer)this, row, column, (RectangularShape)bar, barBase, true);
            }
            if (task != null) {
                Color itemColor = task.getColor();
                if (itemColor != null) {
                    g2.setPaint(itemColor);
                } else {
                    g2.setPaint(this.getItemPaint(row, column));
                }
            }
            this.getBarPainter().paintBar(g2, (BarRenderer)this, row, column, (RectangularShape)bar, barBase);
            if (completeBar != null) {
                g2.setPaint(this.getCompletePaint());
                g2.fill(completeBar);
            }
            if (incompleteBar != null) {
                g2.setPaint(this.getIncompletePaint());
                g2.fill(incompleteBar);
            }
            if (task != null && task.isSelected()) {
                g2.setPaint(Color.BLACK);
                g2.draw(bar);
            }
            if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
                g2.setStroke(this.getItemStroke(row, column));
                g2.setPaint(this.getItemOutlinePaint(row, column));
                g2.draw(bar);
            }
            if (subinterval == count - 1) {
                int datasetIndex = plot.indexOf((CategoryDataset)collection);
                Comparable columnKey = collection.getColumnKey(column);
                Comparable rowKey = collection.getRowKey(row);
                double xx = domainAxis.getCategorySeriesMiddle(columnKey, rowKey, (CategoryDataset)collection, this.getItemMargin(), dataArea, plot.getDomainAxisEdge());
                this.updateCrosshairValues(state.getCrosshairState(), collection.getRowKey(row), collection.getColumnKey(column), value1.doubleValue(), datasetIndex, xx, translatedValue1, orientation);
            }
            if (state.getInfo() == null || (entities = state.getInfo().getOwner().getEntityCollection()) == null) continue;
            String tip = null;
            if (this.getToolTipGenerator(row, column) != null) {
                tip = ((CustomToolTipGenerator)this.getToolTipGenerator(row, column)).generateToolTip((CategoryDataset)collection, row, column, subinterval);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL((CategoryDataset)collection, row, column);
            }
            EFCCategoryItemEntity entity = new EFCCategoryItemEntity(bar, tip, url, (CategoryDataset)collection, collection.getColumnKey(column), collection.getRowKey(row), subinterval);
            entities.add((ChartEntity)entity);
        }
    }
}

