/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.components.panel.EFCOverlapLayout;
import de.effectivecompany.gui.util.EFCSwingUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class EFCGlassPanel
extends JPanel {
    private static DisabledEventQueue queue = new DisabledEventQueue();
    private static Map<Container, List<JComponent>> containers = new HashMap<Container, List<JComponent>>();
    private JComponent glassPane;

    public EFCGlassPanel(Container container) {
        this(container, null);
    }

    public EFCGlassPanel(Container container, Color disabledColor) {
        this.setLayout(new EFCOverlapLayout());
        this.add(container);
        this.glassPane = new GlassPane();
        this.add(this.glassPane);
        if (disabledColor != null) {
            this.glassPane.setBackground(disabledColor);
        }
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
    }

    public Color getDisabledColor() {
        return this.glassPane.getBackground();
    }

    public void setDisabledColor(Color disabledColor) {
        this.glassPane.setBackground(disabledColor);
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent glassPane) {
        this.glassPane = glassPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.glassPane.setVisible(false);
            this.setFocusCycleRoot(false);
            queue.removePanel(this);
        } else {
            this.glassPane.setVisible(true);
            this.setFocusCycleRoot(true);
            queue.addPanel(this);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void disable(Container container) {
        List<JComponent> components = EFCSwingUtil.getDescendantsOfType(JComponent.class, container, true);
        ArrayList<JComponent> enabledComponents = new ArrayList<JComponent>();
        containers.put(container, enabledComponents);
        for (JComponent component : components) {
            if (!component.isEnabled()) continue;
            enabledComponents.add(component);
            component.setEnabled(false);
        }
    }

    public static void enable(Container container) {
        List<JComponent> enabledComponents = containers.get(container);
        if (enabledComponents != null) {
            for (JComponent component : enabledComponents) {
                component.setEnabled(true);
            }
            containers.remove(container);
        }
    }

    static class DisabledEventQueue
    extends EventQueue
    implements WindowListener {
        private Map<EFCGlassPanel, Set<KeyStroke>> panels = new HashMap<EFCGlassPanel, Set<KeyStroke>>();

        DisabledEventQueue() {
        }

        public void addPanel(EFCGlassPanel panel) {
            Set<KeyStroke> keyStrokes = this.getKeyStrokes(panel);
            if (keyStrokes.size() == 0) {
                return;
            }
            this.panels.put(panel, keyStrokes);
            EventQueue current = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (current != this) {
                current.push(queue);
            }
            Window window = SwingUtilities.windowForComponent(panel);
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }

        private Set<KeyStroke> getKeyStrokes(EFCGlassPanel panel) {
            HashSet<KeyStroke> keyStrokes = new HashSet<KeyStroke>();
            Container container = (Container)panel.getComponent(1);
            List<JComponent> components = EFCSwingUtil.getDescendantsOfType(JComponent.class, container);
            for (JComponent component : components) {
                InputMap im = component.getInputMap(2);
                if (im == null || im.allKeys() == null) continue;
                for (KeyStroke keyStroke : im.allKeys()) {
                    keyStrokes.add(keyStroke);
                }
            }
            return keyStrokes;
        }

        public void removePanel(EFCGlassPanel panel) {
            if (this.panels.remove(panel) != null && this.panels.size() == 0) {
                this.pop();
            }
        }

        @Override
        protected void dispatchEvent(AWTEvent event) {
            if (event.getID() == 400 || event.getID() == 401 || event.getID() == 402) {
                KeyEvent keyEvent = (KeyEvent)event;
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                for (EFCGlassPanel panel : this.panels.keySet()) {
                    Window panelWindow = SwingUtilities.windowForComponent(panel);
                    if (panelWindow != keyEvent.getComponent() || !this.searchForKeyBinding(panel, keyStroke)) continue;
                    return;
                }
            }
            super.dispatchEvent(event);
        }

        private boolean searchForKeyBinding(EFCGlassPanel panel, KeyStroke keyStroke) {
            Set<KeyStroke> keyStrokes = this.panels.get(panel);
            return keyStrokes.contains(keyStroke);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ArrayList<EFCGlassPanel> panelsToRemove = new ArrayList<EFCGlassPanel>();
            Window window = e.getWindow();
            for (EFCGlassPanel panel : this.panels.keySet()) {
                Window panelWindow = SwingUtilities.windowForComponent(panel);
                if (panelWindow != window) continue;
                panelsToRemove.add(panel);
            }
            for (EFCGlassPanel panel : panelsToRemove) {
                this.removePanel(panel);
            }
            window.removeWindowListener(this);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    class GlassPane
    extends JComponent {
        public GlassPane() {
            this.setOpaque(false);
            this.setVisible(false);
            Color base = UIManager.getColor("inactiveCaptionBorder");
            base = base == null ? Color.LIGHT_GRAY : base;
            Color background = new Color(base.getRed(), base.getGreen(), base.getBlue(), 0);
            this.setBackground(background);
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }
}

